/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.LongOperations;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableLongMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultLongMatrix;
import ch.javasoft.smx.ops.Add;
import ch.javasoft.smx.ops.ExtendedMatrixOperations;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.smx.ops.Neg;
import ch.javasoft.smx.ops.ScalarOps;
import ch.javasoft.smx.ops.Sub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMatrixOperations
implements MatrixOperations<Long>,
ExtendedMatrixOperations<Long, BigFraction> {
    private static LongMatrixOperations sInstance;

    public static LongMatrixOperations instance() {
        if (sInstance == null) {
            sInstance = new LongMatrixOperations();
        }
        return sInstance;
    }

    public ReadableMatrix<Long> createReadableMatrix(Long[][] values, boolean rowsInFirstDim) {
        return new DefaultLongMatrix(values, rowsInFirstDim);
    }

    @Override
    public ReadableMatrix<Long> createReadableMatrix(int rows, int cols) {
        return new DefaultLongMatrix(rows, cols);
    }

    public WritableMatrix<Long> createWritableMatrix(Long[][] values, boolean rowsInFirstDim) {
        return new DefaultLongMatrix(values, rowsInFirstDim);
    }

    @Override
    public WritableMatrix<Long> createWritableMatrix(int rows, int cols) {
        return new DefaultLongMatrix(rows, cols);
    }

    public ReadableVector<Long> createReadableVector(Long[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    public WritableVector<Long> createWritableVector(Long[] values, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReadableVector<Long> createReadableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public WritableVector<Long> createWritableVector(int size, boolean columnVector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public NumberOperations<Long> getNumberOperations() {
        return LongOperations.instance();
    }

    @Override
    public ReadableMatrix<Long> add(ReadableMatrix<Long> mxA, Long value) {
        if (mxA instanceof ReadableLongMatrix) {
            return ScalarOps.add((ReadableLongMatrix)mxA, value);
        }
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Long> add(ReadableMatrix<Long> mxA, ReadableMatrix<Long> mxB) {
        if (mxA instanceof ReadableLongMatrix && mxB instanceof ReadableLongMatrix) {
            return Add.add((ReadableLongMatrix)mxA, (ReadableLongMatrix)mxB);
        }
        return Add.addGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Long> multiply(ReadableMatrix<Long> mxA, Long value) {
        if (mxA instanceof ReadableLongMatrix) {
            return ScalarOps.scale((ReadableLongMatrix)mxA, value);
        }
        return ScalarOps.scaleGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Long> multiply(ReadableMatrix<Long> mxA, ReadableMatrix<Long> mxB) {
        if (mxA instanceof ReadableLongMatrix && mxB instanceof ReadableLongMatrix) {
            return Add.add((ReadableLongMatrix)mxA, (ReadableLongMatrix)mxB);
        }
        return Mul.multiplyGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Long> negate(ReadableMatrix<Long> matrix) {
        if (matrix instanceof ReadableLongMatrix) {
            return Neg.negate((ReadableLongMatrix)matrix);
        }
        return Neg.negateGeneric(matrix);
    }

    @Override
    public ReadableMatrix<Long> subtract(ReadableMatrix<Long> mxA, Long value) {
        if (mxA instanceof ReadableLongMatrix) {
            return ScalarOps.add((ReadableLongMatrix)mxA, -value.longValue());
        }
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Long> subtract(ReadableMatrix<Long> mxA, ReadableMatrix<Long> mxB) {
        if (mxA instanceof ReadableLongMatrix && mxB instanceof ReadableLongMatrix) {
            return Sub.subtract((ReadableLongMatrix)mxA, (ReadableLongMatrix)mxB);
        }
        return Sub.subtractGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Long> transpose(ReadableMatrix<Long> matrix) {
        return matrix.transpose();
    }

    @Override
    public int rank(ReadableMatrix<Long> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().rank((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public int nullity(ReadableMatrix<Long> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullity((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> invert(ReadableMatrix<Long> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().invert((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    @Override
    public ReadableMatrix<BigFraction> nullspace(ReadableMatrix<Long> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return Gauss.getRationalInstance().nullspace((ReadableBigIntegerRationalMatrix)mx);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }
}

