/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.metabolic;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.polco.config.Phase;
import ch.javasoft.polco.config.PolcoConfig;
import ch.javasoft.polco.config.XmlElement;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.metabolic.LogPkg;
import ch.javasoft.util.numeric.Zero;
import ch.javasoft.xml.config.ConstConfigParser;
import ch.javasoft.xml.config.XmlConfig;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlUtil;
import ch.javasoft.xml.factory.XmlConfiguredFactory;
import java.util.logging.Level;
import org.dom4j.DocumentException;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EfmExtremeRayEnumeratorFactory
implements XmlConfiguredFactory<EfmExtremeRayEnumerator> {
    @Override
    public EfmExtremeRayEnumerator create(Element config) throws ConfigException {
        Zero zero;
        boolean allowMatrixRowScaling;
        try {
            XmlConfig xmlConfig = XmlConfig.getXmlConfig(config.getDocument());
            PolcoConfig.tracePolcoConfig(LogPkg.LOGGER, Level.INFO, xmlConfig);
            ElementaryFluxModes.setImpl(Config.getEfmImpl(xmlConfig, Config.getConfigEfmImpl(xmlConfig)));
            Element elConfig = PolcoConfig.getPolcoConfig(xmlConfig);
            Element elConvert = XmlUtil.getRequiredSingleChildElement(elConfig, XmlElement.convert);
            Element elMatrix = XmlUtil.getRequiredSingleChildElement(elConvert, XmlElement.matrix_scaling);
            allowMatrixRowScaling = ConstConfigParser.parseBooleanConstant(elMatrix);
            zero = PolcoConfig.getZero(xmlConfig, Phase.Core);
        }
        catch (DocumentException e) {
            throw new ConfigException(e, XmlUtil.getElementPath(config, true));
        }
        catch (XmlConfigException e) {
            throw new ConfigException(e, XmlUtil.getElementPath(config, true));
        }
        return new EfmExtremeRayEnumerator(zero, allowMatrixRowScaling);
    }
}

