/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco;

import ch.javasoft.metabolic.Norm;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.polco.PolyhedralCone;
import ch.javasoft.polco.TestHelper;
import ch.javasoft.polco.callback.NullCallback;
import ch.javasoft.polco.config.Arithmetic;
import ch.javasoft.polco.config.ArithmeticCallback;
import ch.javasoft.polco.metabolic.EfmExtremeRayEnumerator;
import ch.javasoft.polco.parse.PolymakeParser;
import ch.javasoft.polco.xenum.ExtremeRayCallback;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Level;
import junit.framework.TestCase;

public class PolymakeTest
extends TestCase {
    private static final File FOLDER_INE = new File("../polymake-data");
    private static final ch.javasoft.metabolic.efm.config.Arithmetic arithmetic;

    static {
        CompressionMethod[] compression = CompressionMethod.NONE;
        arithmetic = ch.javasoft.metabolic.efm.config.Arithmetic.varint;
        if (Config.initForJUnitTest("pattern-tree-minzero", "FewestNegPos", compression, false, arithmetic, Norm.min)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
        }
    }

    public void testMJ_16_17() throws Exception {
        this.internalTestPolymake("MJ:16-17.poly");
    }

    public void testMJ_32_33() throws Exception {
        this.internalTestPolymake("MJ:32-33.poly");
    }

    public void testCUT6() throws Exception {
        this.internalTestPolymake("CUT6:15-32.poly");
    }

    public void testCUT7() throws Exception {
        this.internalTestPolymake("CUT7:21-64.poly");
    }

    public void testCUT8() throws Exception {
        this.internalTestPolymake("CUT8:28-128.poly");
    }

    public void testOA_8_25() throws Exception {
        this.internalTestPolymake("OA:8-25.poly");
    }

    public void testOA_9_33() throws Exception {
        this.internalTestPolymake("OA:9-33.poly");
    }

    public void testOA_10_44() throws Exception {
        this.internalTestPolymake("OA:10-44.poly");
    }

    public void testTC_10_83() throws Exception {
        this.internalTestPolymake("TC:10-83.poly");
    }

    public void testTC_11_106() throws Exception {
        this.internalTestPolymake("TC:11-106.poly");
    }

    public void testTC_12_152() throws Exception {
        this.internalTestPolymake("TC:12-152.poly");
    }

    public void testTC_13_254() throws Exception {
        this.internalTestPolymake("TC:13-254.poly");
    }

    protected void internalTestPolymake(String fileName) throws Exception {
        final File file = new File(FOLDER_INE, fileName);
        TestHelper.getPolcoArithmetic(arithmetic).callback(new ArithmeticCallback<Void>(){

            @Override
            public <N extends Number, A> Void callback(Arithmetic<N, A> arithmetic) throws Exception {
                Zero zero = Config.getConfig().zero();
                PolyhedralCone<N, A> cone = new PolymakeParser().parse(null, arithmetic, zero, new FileInputStream(file));
                EfmExtremeRayEnumerator xray = new EfmExtremeRayEnumerator(zero, true);
                ExtremeRayCallback callback = NullCallback.instance();
                xray.enumerateExtremeRays(cone, callback, arithmetic.getLinAlgOperations(zero));
                return null;
            }
        });
    }
}

