/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.LogPkg;
import ch.javasoft.util.DoubleArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StoichParser {
    public static final Pattern PAT_LINE_PLAIN = Pattern.compile("\\s*(.*)\\s*");
    public static final Pattern PAT_SEP_WHITE = Pattern.compile("\\s+");
    public static final Pattern PAT_SEP_COMMA = Pattern.compile("\\s*,\\s*");
    public static final Pattern PAT_SEP_SEMICOLON = Pattern.compile("\\s*;\\s*");
    public static final Pattern PAT_STR_DOUBLE_QUOTED = Pattern.compile("\"(.*)\"");
    public static final Pattern PAT_STR_SINGLE_QUOTED = Pattern.compile("'(.*)'");
    public static final Pattern PAT_1 = Pattern.compile("1");
    public static final Pattern PAT_0 = Pattern.compile("0");
    private final Pattern mPatStoichLine;
    private final Pattern mPatStoichSep;
    private final Pattern mPatNamesLine;
    private final Pattern mPatNamesSep;
    private final Pattern mPatNamesContent;
    private final Pattern mPatRevsLine;
    private final Pattern mPatRevsSep;
    private final Pattern mPatRevsTrue;
    private final Pattern mPatRevsFalse;

    public StoichParser(Pattern patStoichLine, Pattern patStoichSep, Pattern patNamesLine, Pattern patNamesSep, Pattern patNamesContent, Pattern patRevsLine, Pattern patRevsSep, Pattern patRevsTrue, Pattern patRevsFalse) {
        this.mPatStoichLine = patStoichLine;
        this.mPatStoichSep = patStoichSep;
        this.mPatNamesLine = patNamesLine;
        this.mPatNamesSep = patNamesSep;
        this.mPatNamesContent = patNamesContent;
        this.mPatRevsLine = patRevsLine;
        this.mPatRevsSep = patRevsSep;
        this.mPatRevsTrue = patRevsTrue;
        this.mPatRevsFalse = patRevsFalse;
    }

    public static StoichParser getSeparatorStoichParser(String separator) {
        Pattern pattern = Pattern.compile("\\s*[" + separator + "]\\s*");
        return new StoichParser(PAT_LINE_PLAIN, pattern, PAT_LINE_PLAIN, pattern, PAT_STR_DOUBLE_QUOTED, PAT_LINE_PLAIN, pattern, PAT_1, PAT_0);
    }

    public static StoichParser getCommaSeparatedStoichParser() {
        return new StoichParser(PAT_LINE_PLAIN, PAT_SEP_COMMA, PAT_LINE_PLAIN, PAT_SEP_COMMA, PAT_STR_DOUBLE_QUOTED, PAT_LINE_PLAIN, PAT_SEP_COMMA, PAT_1, PAT_0);
    }

    public static StoichParser getWhitespaceSeparatedStoichParser() {
        return new StoichParser(PAT_LINE_PLAIN, PAT_SEP_WHITE, PAT_LINE_PLAIN, PAT_SEP_WHITE, PAT_STR_DOUBLE_QUOTED, PAT_LINE_PLAIN, PAT_SEP_WHITE, PAT_1, PAT_0);
    }

    public static StoichParser getSemicolonSeparatedStoichParser() {
        return new StoichParser(PAT_LINE_PLAIN, PAT_SEP_SEMICOLON, PAT_LINE_PLAIN, PAT_SEP_SEMICOLON, PAT_STR_DOUBLE_QUOTED, PAT_LINE_PLAIN, PAT_SEP_SEMICOLON, PAT_1, PAT_0);
    }

    public MetabolicNetwork parse(BufferedReader stoichReader, BufferedReader metaReader, BufferedReader reacReader, BufferedReader revReader) throws IOException {
        int cntR;
        double[][] stoich = this.parseStoich(stoichReader);
        String[] metaNames = this.parseMetaboliteNames(metaReader);
        String[] reacNames = this.parseReactionNames(reacReader);
        boolean[] revs = this.parseReactionReversibilities(revReader);
        int cntM = stoich.length;
        int n = cntR = cntM == 0 ? 0 : stoich[0].length;
        if (cntM != metaNames.length) {
            throw new IOException("expected " + cntM + " metabolite names, but found " + metaNames.length);
        }
        if (cntR != reacNames.length) {
            throw new IOException("expected " + cntR + " reaction names, but found " + reacNames.length);
        }
        if (cntR != revs.length) {
            throw new IOException("expected " + cntR + " reversibilities, but found " + revs.length);
        }
        return new DefaultMetabolicNetwork(metaNames, reacNames, stoich, revs);
    }

    public String[] parseReactionNames(BufferedReader reacReader) throws IOException {
        return this.parseNames(reacReader);
    }

    public String[] parseMetaboliteNames(BufferedReader metaReader) throws IOException {
        return this.parseNames(metaReader);
    }

    public boolean[] parseReactionReversibilities(BufferedReader reader) throws IOException {
        String line = null;
        int lineNo = 0;
        try {
            line = reader.readLine();
            if (line == null) {
                throw new IOException("unexpected end of file");
            }
            ++lineNo;
            String content = StoichParser.getContent(this.mPatRevsLine, line);
            String[] values = this.mPatRevsSep.split(content);
            boolean[] revs = new boolean[values.length];
            int i = 0;
            while (i < revs.length) {
                if (this.mPatRevsTrue.matcher(values[i]).matches()) {
                    revs[i] = true;
                } else if (this.mPatRevsFalse.matcher(values[i]).matches()) {
                    revs[i] = false;
                } else {
                    throw new IOException("cannot parse boolean value " + values[i]);
                }
                ++i;
            }
            line = reader.readLine();
            if (line != null) {
                LogPkg.LOGGER.warning("extra lines found, will be ignored");
                LogPkg.LOGGER.warning("LINE: " + line);
            }
            return revs;
        }
        catch (IOException ex) {
            String msg = String.valueOf(ex.getLocalizedMessage()) + " [line " + lineNo + "]";
            LogPkg.LOGGER.warning(msg);
            LogPkg.LOGGER.warning("LINE: " + line);
            throw new IOException(msg);
        }
    }

    private String[] parseNames(BufferedReader reader) throws IOException {
        String line = null;
        int lineNo = 0;
        try {
            line = reader.readLine();
            if (line == null) {
                throw new IOException("unexpected end of file");
            }
            ++lineNo;
            String content = StoichParser.getContent(this.mPatNamesLine, line);
            String[] values = this.mPatNamesSep.split(content);
            String[] names = new String[values.length];
            int i = 0;
            while (i < names.length) {
                names[i] = StoichParser.getContent(this.mPatNamesContent, values[i]);
                ++i;
            }
            line = reader.readLine();
            if (line != null) {
                LogPkg.LOGGER.warning("extra lines found, will be ignored");
                LogPkg.LOGGER.warning("LINE: " + line);
            }
            return names;
        }
        catch (IOException ex) {
            String msg = String.valueOf(ex.getLocalizedMessage()) + " [line " + lineNo + "]";
            LogPkg.LOGGER.warning(msg);
            LogPkg.LOGGER.warning("LINE: " + line);
            throw new IOException(msg);
        }
    }

    public double[][] parseStoich(BufferedReader stoichReader) throws IOException {
        String line = null;
        int lineNo = 0;
        int cols = -1;
        try {
            ArrayList<DoubleArray> rows = new ArrayList<DoubleArray>();
            while ((line = stoichReader.readLine()) != null) {
                ++lineNo;
                String content = StoichParser.getContent(this.mPatStoichLine, line);
                String[] values = this.mPatStoichSep.split(content);
                if (values.length != cols) {
                    if (cols == -1) {
                        cols = values.length;
                    } else {
                        LogPkg.LOGGER.warning("expected " + cols + " values, but found " + values.length + " [line " + lineNo + "]");
                        cols = Math.max(cols, values.length);
                    }
                }
                DoubleArray row = new DoubleArray(values.length);
                int i = 0;
                while (i < values.length) {
                    try {
                        row.set(i, Double.parseDouble(values[i]));
                    }
                    catch (NumberFormatException ex) {
                        LogPkg.LOGGER.warning(ex.toString());
                        throw new IOException("cannot parse numeric value " + values[i]);
                    }
                    ++i;
                }
                rows.add(row);
            }
            double[][] stoich = new double[rows.size()][cols];
            int row = 0;
            while (row < stoich.length) {
                DoubleArray vals = (DoubleArray)rows.get(row);
                int col = 0;
                while (col < vals.length()) {
                    stoich[row][col] = vals.get(col);
                    ++col;
                }
                ++row;
            }
            return stoich;
        }
        catch (IOException ex) {
            String msg = String.valueOf(ex.getLocalizedMessage()) + " [line " + lineNo + "]";
            LogPkg.LOGGER.warning(msg);
            LogPkg.LOGGER.warning("LINE: " + line);
            throw new IOException(msg);
        }
    }

    private static String getContent(Pattern contentPattern, String line) throws IOException {
        String content;
        Matcher lineMatcher = contentPattern.matcher(line);
        if (!lineMatcher.matches()) {
            throw new IOException("syntax error, expected pattern: " + contentPattern.pattern());
        }
        try {
            content = lineMatcher.group(1);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IOException("pattern must contain a group 1");
        }
        return content;
    }
}

