/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.progress;

import ch.javasoft.metabolic.efm.progress.AbstractStringProgressWriter;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class JProgress
extends AbstractStringProgressWriter {
    private final ProgressMonitor jmonitor;

    public JProgress(AbstractStringProgressWriter.Mode mode, int n, int iteration) {
        this(mode, n, iteration, 0L, 0L);
    }

    public JProgress(AbstractStringProgressWriter.Mode mode, int n, int iteration, long posCount, long negCount) {
        super(mode, n);
        String title;
        if (posCount > 0L && negCount > 0L) {
            NumberFormat nf = (NumberFormat)NumberFormat.getIntegerInstance().clone();
            nf.setGroupingUsed(true);
            title = "Iteration " + iteration + "\nAdjacency candidates to check: " + nf.format(posCount * negCount) + "\n\n";
        } else {
            title = "Iteration " + iteration + "\nChecking adjacency candidates...\n\n";
        }
        this.jmonitor = new ProgressMonitor(null, title, "Progress: 0%", 0, 1000);
    }

    protected void write(final double progress, final String msg) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JProgress.this.jmonitor.isCanceled()) {
                    System.exit(1);
                    return;
                }
                JProgress.this.jmonitor.setNote("Progress: " + msg);
                JProgress.this.jmonitor.setProgress((int)(1000.0 * progress));
            }
        });
    }

    public void close() throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JProgress.this.jmonitor.close();
            }
        });
    }
}

