/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.DefaultIterationStepModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjEnumModel<Col extends Column>
extends DefaultIterationStepModel {
    private final SortableMemory<Col> pos;
    private final SortableMemory<Col> zero;
    private final SortableMemory<Col> neg;
    private final AppendableMemory<Col> out;

    public AdjEnumModel(NetworkEfmModel efmModel, int iterationIndex, SortableMemory<Col> pos, SortableMemory<Col> zero, SortableMemory<Col> neg, AppendableMemory<Col> out) {
        super(efmModel, iterationIndex);
        this.pos = pos;
        this.zero = zero;
        this.neg = neg;
        this.out = out;
    }

    public AdjEnumModel(IterationStepModel stepModel, SortableMemory<Col> pos, SortableMemory<Col> zero, SortableMemory<Col> neg, AppendableMemory<Col> out) {
        super(stepModel);
        this.pos = pos;
        this.zero = zero;
        this.neg = neg;
        this.out = out;
    }

    public SortableMemory<Col> getMemory(PartId part) {
        switch (part) {
            case POS: {
                return this.getMemoryPos();
            }
            case NEG: {
                return this.getMemoryNeg();
            }
            case ZER: {
                return this.getMemoryZero();
            }
        }
        throw new IllegalArgumentException("unsupported memory part: " + part);
    }

    public SortableMemory<Col> getMemoryPos() {
        return this.pos;
    }

    public SortableMemory<Col> getMemoryZero() {
        return this.zero;
    }

    public SortableMemory<Col> getMemoryNeg() {
        return this.neg;
    }

    public AppendableMemory<Col> getMemoryForNewFromAdj() {
        return this.out;
    }

    @Override
    public void closeForThread() throws IOException {
        this.pos.close(false);
        if (this.zero != null) {
            this.zero.close(false);
        }
        this.neg.close(false);
    }
}

