/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.VariableWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigFractionOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.FractionNumberFluxDistribution;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionalColumn
extends AbstractColumn {
    private int mBoolSize;
    private final IBitSet mBitSet;
    private BigFraction[] mValues;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.fractional;
        }

        @Override
        public NumberOperations<BigFraction> getNumberOperations() {
            return BigFractionOperations.instance();
        }

        @Override
        public FractionalColumn newInstance(int booleanSize, int numericSize) {
            throw new RuntimeException("not implemented");
        }

        public FractionalColumn[] newInstances(ReadableMatrix<BigFraction> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            FractionalColumn[] res = new FractionalColumn[cols];
            int col = 0;
            while (col < cols) {
                BigFraction[] vals = new BigFraction[rows];
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col).reduce();
                    ++row;
                }
                res[col] = new FractionalColumn(booleanSize, BitSetUtil.factory().create(rows), vals);
                ++col;
            }
            return res;
        }

        @Override
        public FractionalColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            BigFraction[] values = new BigFraction[numericSize];
            int i = 0;
            while (i < numericSize) {
                int byteCnt = dataIn.readInt();
                byte[] numBytes = new byte[byteCnt];
                int j = 0;
                while (j < numBytes.length) {
                    numBytes[j] = dataIn.readByte();
                    ++j;
                }
                byteCnt = dataIn.readInt();
                byte[] denBytes = new byte[byteCnt];
                j = 0;
                while (j < denBytes.length) {
                    denBytes[j] = dataIn.readByte();
                    ++j;
                }
                BigInteger num = new BigInteger(numBytes);
                BigInteger den = new BigInteger(denBytes);
                values[i] = new BigFraction(numBytes.length <= 8 ? BigInteger.valueOf(num.longValue()) : num, denBytes.length <= 8 ? BigInteger.valueOf(den.longValue()) : den);
                ++i;
            }
            return new FractionalColumn(booleanSize, bitSet, values);
        }

        @Override
        public void writeTo(FractionalColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            int i = 0;
            while (i < column.mValues.length) {
                byte[] bytes = column.mValues[i].getNumerator().toByteArray();
                dataOut.writeInt(bytes.length);
                int j = 0;
                while (j < bytes.length) {
                    dataOut.writeByte(bytes[j]);
                    ++j;
                }
                bytes = column.mValues[i].getDenominator().toByteArray();
                dataOut.writeInt(bytes.length);
                j = 0;
                while (j < bytes.length) {
                    dataOut.writeByte(bytes[j]);
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public EntityMarshaller<FractionalColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            return new EntityMarshaller<FractionalColumn>(){

                @Override
                public FractionalColumn readFrom(DataInput in) throws IOException {
                    return (FractionalColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(FractionalColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<FractionalColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            int boolByteLen = (booleanSize - 1) / 8 + 1;
            int numericByteLen = numericSize * 24;
            return new ConcurrentTable<FractionalColumn>(VariableWidthTable.create(folder, fileName, boolByteLen + numericByteLen, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigFractionMemoryTable.getCacheTableSize(), Cache.BigFractionMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<FractionalColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<FractionalColumn>(VariableWidthTable.open(folder, fileName, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigFractionMemoryTable.getCacheTableSize(), Cache.BigFractionMemoryTable.getCacheEntrySize()));
        }

        public FluxDistribution createFluxDistribution(MetabolicNetwork net, BigFraction[] values) {
            return new FractionNumberFluxDistribution(net, values);
        }

        @Override
        public ReadableMatrix<BigFraction> convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof ReadableBigIntegerRationalMatrix) {
                return ((ReadableBigIntegerRationalMatrix)matrix).toBigIntegerRationalMatrix(false);
            }
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DefaultBigIntegerRationalMatrix mx = new DefaultBigIntegerRationalMatrix(rows, cols);
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    mx.setValueAt(row, col, BigFraction.valueOf(matrix.getNumberValueAt(row, col)));
                    ++col;
                }
                ++row;
            }
            return mx;
        }

        @Override
        public ReadableMatrix<BigFraction> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof ReadableBigIntegerRationalMatrix) {
                return ((ReadableBigIntegerRationalMatrix)matrix).toBigIntegerRationalMatrix(false);
            }
            throw new ClassCastException("not a ReadableBigIntegerRationalMatrix: " + matrix.getClass().getName());
        }

        @Override
        public FractionalColumn castColumn(Column column) {
            return (FractionalColumn)column;
        }

        @Override
        public BigFraction castNumber(Number number) {
            return (BigFraction)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableBigIntegerRationalMatrix)matrix);
        }
    };

    public FractionalColumn(int boolSize) {
        this.mBoolSize = boolSize;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mValues = new BigFraction[0];
    }

    protected FractionalColumn(int boolSize, IBitSet bitSet, BigFraction[] values) {
        this.mBoolSize = boolSize;
        this.mBitSet = bitSet;
        this.mValues = values;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        return columnHome.castNumber(this.mValues[row]);
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mValues.length;
    }

    public int size() {
        return this.mBoolSize + this.mValues.length;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return this.mValues[row].signum();
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return FractionalColumn.getColumnInspectorModifier(model, BigFraction.class, BigFraction[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        ColumnInspectorModifier<BigFraction, BigFraction[]> modifier = FractionalColumn.getColumnInspectorModifier(model, BigFraction.class, BigFraction[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        BigFraction[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new FractionalColumn(iteration.getNextState().getBooleanSize(), newBin, newNum));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mValues = newNum;
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (FractionalColumn)other, iteration));
    }

    public FractionalColumn mergeWith(EfmModel model, FractionalColumn other, IterationStepModel iteration) {
        ColumnInspectorModifier<BigFraction, BigFraction[]> modifier = FractionalColumn.getColumnInspectorModifier(model, BigFraction.class, BigFraction[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        BigFraction[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        return new FractionalColumn(iteration.getNextState().getBooleanSize(), newBin, newNum);
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    @Override
    public FractionalColumn clone() {
        return new FractionalColumn(this.mBoolSize, this.mBitSet.clone(), (BigFraction[])this.mValues.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FractionalColumn) {
            FractionalColumn col = (FractionalColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && Arrays.equals(this.mValues, col.mValues);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        ii = 0;
        while (ii < this.mValues.length) {
            if (this.mBoolSize > 0 || ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mValues[ii]);
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<BigFraction, FractionalColumn>
    implements ColumnHome<BigFraction, FractionalColumn> {
    }
}

