/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.range;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.borndie.memory.ColumnDemuxAppendableMemory;
import ch.javasoft.metabolic.efm.borndie.range.AbstractRectangularRange;
import ch.javasoft.metabolic.efm.borndie.range.ColumnRange;
import ch.javasoft.metabolic.efm.column.Column;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultColumnRange
extends AbstractRectangularRange
implements ColumnRange {
    private final int bornColumn;
    private final int dieRowFrom;
    private final int dieRowTo;

    public DefaultColumnRange(int bornColumn, int dieRowFrom, int dieRowTo) {
        if (dieRowFrom < 0) {
            throw new IndexOutOfBoundsException("row from is negative: " + dieRowFrom);
        }
        if (dieRowTo < dieRowFrom) {
            throw new IndexOutOfBoundsException("row from is larger than to: " + dieRowFrom + ">" + dieRowTo);
        }
        if (bornColumn < 0) {
            throw new IndexOutOfBoundsException("column is negative: " + bornColumn);
        }
        this.bornColumn = bornColumn;
        this.dieRowFrom = dieRowFrom;
        this.dieRowTo = dieRowTo;
    }

    @Override
    public int getBornColumn() {
        return this.bornColumn;
    }

    @Override
    public int getBornColumnFrom() {
        return this.bornColumn;
    }

    @Override
    public int getBornColumnTo() {
        return this.bornColumn + 1;
    }

    @Override
    public int getDieRowFrom() {
        return this.dieRowFrom;
    }

    @Override
    public int getDieRowTo() {
        return this.dieRowTo;
    }

    public <Col extends Column> ColumnDemuxAppendableMemory<Col> getForAppending(BornDieController<Col> controller) throws IllegalStateException, IOException {
        return new ColumnDemuxAppendableMemory<Col>(controller, this.getBornColumn());
    }
}

