/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.CountOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.NullOutputCallback;
import ch.javasoft.metabolic.efm.output.OptimizerOutputCallback;
import ch.javasoft.metabolic.efm.output.OutputMode;
import ch.javasoft.metabolic.efm.output.TextOutputCallback;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputCallback;
import ch.javasoft.metabolic.efm.output.text.NumberTextOutputFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementaryFluxModes {
    private static Impl sImpl;

    public static void setImpl(Impl impl) {
        sImpl = impl;
    }

    public static Impl getImpl() {
        if (sImpl == null) {
            throw new IllegalStateException("efm impl not initialized");
        }
        return sImpl;
    }

    public static void calculateLogNull(MetabolicNetwork metaNet) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, NullOutputCallback.INSTANCE);
    }

    public static long calculateLogCountOnly(MetabolicNetwork metaNet) {
        CountOutputCallback cb = new CountOutputCallback(true);
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, cb);
        return cb.getEfmCount();
    }

    public static void calculateLogBinary(MetabolicNetwork metaNet) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.BinaryUncompressed));
    }

    public static void calculateLogDoubles(MetabolicNetwork metaNet) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.DoubleUncompressed));
    }

    public static void calculateLogSigns(MetabolicNetwork metaNet) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.SignUncompressed));
    }

    public static void calculateLogNumbers(MetabolicNetwork metaNet) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.DoubleUncompressed, new NumberTextOutputFormatter(false, false)));
    }

    public static void calculateLogMinMax(MetabolicNetwork metaNet, double[] costFunction, boolean callbackForAllEfms) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new OptimizerOutputCallback(new TextOutputCallback(metaNet, OutputMode.DoubleUncompressed), costFunction, callbackForAllEfms));
    }

    public static void calculateFileMatlab(MetabolicNetwork metaNet, File folder, String fileName) throws IOException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new MatFileOutputCallback(metaNet, folder, fileName));
    }

    public static void calculateFileMatlab(MetabolicNetwork metaNet, OutputMode mode, File folder, String fileName) throws IOException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new MatFileOutputCallback(mode, metaNet, folder, fileName));
    }

    public static void calculateFileBinary(MetabolicNetwork metaNet, File file) throws IOException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.BinaryUncompressed, new FileOutputStream(file), true));
    }

    public static void calculateFileBinary(MetabolicNetwork metaNet, OutputMode mode, File file) throws IOException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, mode, new FileOutputStream(file), true));
    }

    public static void calculateFileDoubles(MetabolicNetwork metaNet, File file) throws FileNotFoundException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.DoubleUncompressed, new FileOutputStream(file), true));
    }

    public static void calculateFileSigns(MetabolicNetwork metaNet, File file) throws FileNotFoundException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.SignUncompressed, new FileOutputStream(file), true));
    }

    public static void calculateFileNumbers(MetabolicNetwork metaNet, File file) throws FileNotFoundException {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, new TextOutputCallback(metaNet, OutputMode.DoubleUncompressed, new FileOutputStream(file), (EfmOutputFormatter<PrintWriter>)new NumberTextOutputFormatter(false, false), true));
    }

    public static void calculateCallback(MetabolicNetwork metaNet, EfmOutputCallback callback) {
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, callback);
    }

    public static Iterable<? extends FluxDistribution> calculateAndReturnEfms(MetabolicNetwork metaNet) {
        final ConcurrentLinkedQueue res = new ConcurrentLinkedQueue();
        EfmOutputCallback cb = new EfmOutputCallback(){

            public CallbackGranularity getGranularity() {
                return CallbackGranularity.DoubleUncompressed;
            }

            public void callback(EfmOutputEvent evt) {
                if (evt.getKind() == EfmOutputEvent.Kind.EFM_OUT) {
                    res.add(evt.getEfm());
                }
            }

            public boolean allowLoggingDuringOutput() {
                return true;
            }

            public boolean isThreadSafe() {
                return true;
            }
        };
        ElementaryFluxModes.getImpl().calculateEfms(metaNet, cb);
        return res;
    }

    private ElementaryFluxModes() {
    }

    public static interface Impl {
        public String getImplName();

        public void calculateEfms(MetabolicNetwork var1, EfmOutputCallback var2);

        public Config getConfig();
    }
}

