/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.compose;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import ch.javasoft.math.operator.compose.TempArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullaryUnaryOperator<T extends Number, A>
extends AbstractUnaryOperator<T, A> {
    private final BinaryOperator<T, A> operator;
    private final NullaryOperator<T, A> operand1;
    private final UnaryOperator<T, A> operand2;
    private final TempArray<A> temp;

    public NullaryUnaryOperator(ArrayOperations<A> ops, BinaryOperator<T, A> operator, NullaryOperator<T, A> operand1, UnaryOperator<T, A> operand2) {
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.temp = new TempArray<A>(ops, 2);
    }

    @Override
    public T operate(T operand) {
        Number operated1 = (Number)this.operand1.operate();
        Number operated2 = (Number)this.operand2.operate(operand);
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public T operate(A src, int srcIndex) {
        Number operated1 = (Number)this.operand1.operate();
        Number operated2 = (Number)this.operand2.operate(src, srcIndex);
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public void operate(A src, int srcIndex, A dst, int dstIndex) {
        A tmp = this.temp.get();
        this.operand1.operate(tmp, 0);
        this.operand2.operate(src, srcIndex, tmp, 1);
        this.operator.operate(tmp, 0, tmp, 1, dst, dstIndex);
    }
}

