/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg.impl;

import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.linalg.GaussPivoting;
import ch.javasoft.math.linalg.GaussPivotingFactory;

public class DoubleGaussPivoting {
    public static GaussPivotingFactory<Double, double[]> ABS_G = new GaussPivotingFactory<Double, double[]>(){

        @Override
        public GaussPivoting<Double, double[]> getGaussPivoting(NumberArrayOperations<Double, double[]> numberOps, int pivot) {
            return new AbsG(pivot);
        }
    };
    public static GaussPivotingFactory<Double, double[]> ABS_GE = new GaussPivotingFactory<Double, double[]>(){

        @Override
        public GaussPivoting<Double, double[]> getGaussPivoting(NumberArrayOperations<Double, double[]> numberOps, int pivot) {
            return new AbsGE(pivot);
        }
    };

    private DoubleGaussPivoting() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbsG
    implements GaussPivoting<Double, double[]> {
        private int pivCol;
        private int pivRow;
        private double pivValAbs = 0.0;

        public AbsG(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(double[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(double[][] matrix, int pivot, int row, int col, int rowResult) {
            double abs = Math.abs(matrix[row][col]);
            if (abs > this.pivValAbs) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivValAbs = abs;
            }
            return true;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbsGE
    implements GaussPivoting<Double, double[]> {
        private int pivCol;
        private int pivRow;
        private double pivValAbs = 0.0;

        public AbsGE(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(double[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(double[][] matrix, int pivot, int row, int col, int rowResult) {
            double abs = Math.abs(matrix[row][col]);
            if (abs >= this.pivValAbs) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivValAbs = abs;
            }
            return true;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }
}

