/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.linalg.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.linalg.GaussPivoting;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigFractionGaussPivoting {
    public static GaussPivotingFactory<BigFraction, BigFraction[]> LEN_PRODUCT_L = new GaussPivotingFactory<BigFraction, BigFraction[]>(){

        @Override
        public GaussPivoting<BigFraction, BigFraction[]> getGaussPivoting(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            return new LenProductL(pivot);
        }
    };
    public static GaussPivotingFactory<BigFraction, BigFraction[]> LEN_PRODUCT_LE = new GaussPivotingFactory<BigFraction, BigFraction[]>(){

        @Override
        public GaussPivoting<BigFraction, BigFraction[]> getGaussPivoting(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            return new LenProductLE(pivot);
        }
    };
    public static GaussPivotingFactory<BigFraction, BigFraction[]> LEN_PRODUCT_L_OR_E_AND_MORE_ROW_ZEROS = new GaussPivotingFactory<BigFraction, BigFraction[]>(){

        @Override
        public GaussPivoting<BigFraction, BigFraction[]> getGaussPivoting(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            return new LenProductLorEandMoreRowZeros(numberOps, pivot);
        }
    };
    public static GaussPivotingFactory<BigFraction, BigFraction[]> LEN_SUM_L_OR_E_AND_MORE_ROW_ZEROS = new GaussPivotingFactory<BigFraction, BigFraction[]>(){

        @Override
        public GaussPivoting<BigFraction, BigFraction[]> getGaussPivoting(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            return new LenSumLorEandMoreRowZeros(numberOps, pivot);
        }
    };
    public static GaussPivotingFactory<BigFraction, BigFraction[]> MAX_LEN_L_OR_E_AND_MORE_ROW_ZEROS = new GaussPivotingFactory<BigFraction, BigFraction[]>(){

        @Override
        public GaussPivoting<BigFraction, BigFraction[]> getGaussPivoting(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            return new MaxLenLorEandMoreRowZeros(numberOps, pivot);
        }
    };

    private static boolean isZero(NumberArrayOperations<BigFraction, BigFraction[]> nops, BigFraction value) {
        return nops.getNumberOperators().booleanUnary(BooleanUnaryOperator.Id.isZero).booleanOperate(value);
    }

    private BigFractionGaussPivoting() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenProductL
    implements GaussPivoting<BigFraction, BigFraction[]> {
        private int pivCol;
        private int pivRow;
        private int pivPro = Integer.MAX_VALUE;

        public LenProductL(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigFraction[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(BigFraction[][] matrix, int pivot, int row, int col, int rowResult) {
            BigInteger num = matrix[row][col].getNumerator();
            BigInteger den = matrix[row][col].getDenominator();
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro < this.pivPro) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
            }
            return this.pivPro != 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenProductLE
    implements GaussPivoting<BigFraction, BigFraction[]> {
        private int pivCol;
        private int pivRow;
        private int pivPro = Integer.MAX_VALUE;

        public LenProductLE(int pivot) {
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigFraction[][] matrix, int pivot, int row) {
            return 0;
        }

        public boolean checkCandidateCol(BigFraction[][] matrix, int pivot, int row, int col, int rowResult) {
            BigInteger num = matrix[row][col].getNumerator();
            BigInteger den = matrix[row][col].getDenominator();
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro <= this.pivPro) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
            }
            return true;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenProductLorEandMoreRowZeros
    implements GaussPivoting<BigFraction, BigFraction[]> {
        private final NumberArrayOperations<BigFraction, BigFraction[]> numberOps;
        private int pivCol;
        private int pivRow;
        private int pivPro = Integer.MAX_VALUE;
        private int pivCnt = 0;

        public LenProductLorEandMoreRowZeros(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            this.numberOps = numberOps;
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigFraction[][] matrix, int pivot, int row) {
            int cols = matrix[row].length;
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (BigFractionGaussPivoting.isZero(this.numberOps, matrix[row][col])) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        public boolean checkCandidateCol(BigFraction[][] matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix[row][col].getNumerator();
            BigInteger den = matrix[row][col].getDenominator();
            int pro = num.abs().bitLength() * den.abs().bitLength();
            if (pro < this.pivPro || pro == this.pivPro && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivPro = pro;
                this.pivCnt = zerCnt;
            }
            int cols = matrix[row].length;
            return this.pivPro != 1 || this.pivCnt < cols - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LenSumLorEandMoreRowZeros
    implements GaussPivoting<BigFraction, BigFraction[]> {
        private final NumberArrayOperations<BigFraction, BigFraction[]> numberOps;
        private int pivCol;
        private int pivRow;
        private int pivSum = Integer.MAX_VALUE;
        private int pivCnt = 0;

        public LenSumLorEandMoreRowZeros(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            this.numberOps = numberOps;
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigFraction[][] matrix, int pivot, int row) {
            int cols = matrix[row].length;
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (BigFractionGaussPivoting.isZero(this.numberOps, matrix[row][col])) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        public boolean checkCandidateCol(BigFraction[][] matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix[row][col].getNumerator();
            BigInteger den = matrix[row][col].getDenominator();
            int sum = num.abs().bitLength() + den.abs().bitLength();
            if (sum < this.pivSum || sum == this.pivSum && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivSum = sum;
                this.pivCnt = zerCnt;
            }
            int cols = matrix[row].length;
            return this.pivSum != 2 || this.pivCnt < cols - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MaxLenLorEandMoreRowZeros
    implements GaussPivoting<BigFraction, BigFraction[]> {
        private final NumberArrayOperations<BigFraction, BigFraction[]> numberOps;
        private int pivCol;
        private int pivRow;
        private int pivLen = Integer.MAX_VALUE;
        private int pivCnt = 0;

        public MaxLenLorEandMoreRowZeros(NumberArrayOperations<BigFraction, BigFraction[]> numberOps, int pivot) {
            this.numberOps = numberOps;
            this.pivRow = pivot;
            this.pivCol = pivot;
        }

        public int checkCandidateRow(BigFraction[][] matrix, int pivot, int row) {
            int cols = matrix[row].length;
            int zerCnt = 0;
            int col = pivot;
            while (col < cols) {
                if (BigFractionGaussPivoting.isZero(this.numberOps, matrix[row][col])) {
                    ++zerCnt;
                }
                ++col;
            }
            return zerCnt;
        }

        public boolean checkCandidateCol(BigFraction[][] matrix, int pivot, int row, int col, int zerCnt) {
            BigInteger num = matrix[row][col].getNumerator();
            BigInteger den = matrix[row][col].getDenominator();
            int len = Math.max(num.abs().bitLength(), den.abs().bitLength());
            if (len < this.pivLen || len == this.pivLen && zerCnt > this.pivCnt) {
                this.pivCol = col;
                this.pivRow = row;
                this.pivLen = len;
                this.pivCnt = zerCnt;
            }
            int cols = matrix[row].length;
            return this.pivLen != 1 || this.pivCnt < cols - 1;
        }

        @Override
        public int getPivotCol() {
            return this.pivCol;
        }

        @Override
        public int getPivotRow() {
            return this.pivRow;
        }
    }
}

