/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.parse;

import ch.javasoft.math.NumberMatrixConverter;
import ch.javasoft.math.array.parse.DataType;
import ch.javasoft.math.array.parse.MatrixData;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMatrixData
implements MatrixData {
    private final DataType type;
    private final Object[] matrix;

    public DefaultMatrixData(DataType type, List<? extends Object> values) {
        this.type = type;
        this.matrix = type.toMatrix(values);
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public int getRowCount() {
        return this.matrix.length;
    }

    @Override
    public int getColumnCount() {
        return this.matrix.length == 0 ? 0 : this.type.getVectorLength(this.matrix[0]);
    }

    @Override
    public Number getValue(int row, int col) {
        return this.type.getMatrixValue(this.matrix, row, col);
    }

    @Override
    public <A> A[] getMatrixCast(Class<A> arrayClass) throws ClassCastException {
        return DataType.castMatrix(arrayClass, this.matrix);
    }

    @Override
    public <A> A[] getMatrixConverted(NumberMatrixConverter<A> converter) throws ClassCastException {
        int rows = this.matrix.length;
        int cols = rows == 0 ? 0 : this.type.getVectorLength(this.matrix[0]);
        A[] dst = converter.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                Number val = this.type.getMatrixValue(this.matrix, r, c);
                converter.copy(val, dst, r, c);
                ++c;
            }
            ++r;
        }
        return dst;
    }

    public String toString() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        return String.valueOf(rows) + "x" + cols + " (" + (Object)((Object)this.type) + ")";
    }
}

