/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat;

import ch.javasoft.jsmat.MatFileHeader;
import ch.javasoft.jsmat.ReservedComplexWriter;
import ch.javasoft.jsmat.ReservedMatrixWriter;
import ch.javasoft.jsmat.ReservedWriter;
import ch.javasoft.jsmat.VariableWriter;
import ch.javasoft.jsmat.variable.MatAllocated;
import ch.javasoft.jsmat.variable.MatReserved;
import ch.javasoft.jsmat.variable.MatReservedComplex;
import ch.javasoft.jsmat.variable.MatReservedMatrix;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatWriter<D extends DataOutput> {
    protected ReservedWriter mReservedWriter = null;

    public MatWriter(D out) throws IOException {
        this.initDataOutput(out);
        this.writeHeader((DataOutput)out);
    }

    protected abstract void initDataOutput(D var1) throws IOException;

    protected abstract VariableWriter createVariableWriter() throws IOException;

    public void write(String name, MatAllocated variable) throws IOException {
        this.checkNoReservedWriter();
        VariableWriter writer = this.createVariableWriter();
        variable.write(name, writer.open());
        writer.close();
    }

    protected void checkNoReservedWriter() throws IOException {
        if (this.mReservedWriter != null) {
            throw new IOException("unclosed reserved writer found, close it first");
        }
    }

    public ReservedComplexWriter createReservedWriter(String name, MatReservedComplex reserved) throws IOException {
        this.checkNoReservedWriter();
        ReservedComplexWriter writer = new ReservedComplexWriter(this, (MatReserved)reserved);
        this.mReservedWriter = writer;
        writer.open(name);
        return writer;
    }

    public <A> ReservedMatrixWriter<A> createReservedWriter(String name, MatReservedMatrix<A> reserved) throws IOException {
        ReservedMatrixWriter<A> writer;
        this.checkNoReservedWriter();
        this.mReservedWriter = writer = new ReservedMatrixWriter<A>((MatWriter<? extends DataOutput>)this, reserved);
        writer.open(name);
        return writer;
    }

    public void write(Map<String, ? extends MatAllocated> variables) throws IOException {
        for (String name : variables.keySet()) {
            MatAllocated variable = variables.get(name);
            this.write(name, variable);
        }
    }

    public abstract void close() throws IOException;

    private void writeHeader(DataOutput out) throws IOException {
        MatFileHeader header = MatFileHeader.createHeader();
        char[] dest = new char[116];
        char[] src = header.getDescription().toCharArray();
        System.arraycopy(src, 0, dest, 0, src.length);
        int i = 0;
        while (i < dest.length) {
            out.writeByte(dest[i]);
            ++i;
        }
        out.write(new byte[8]);
        int version = header.getVersion();
        out.writeByte(version >> 8);
        out.writeByte(version);
        out.write(header.getEndianIndicator());
    }
}

