/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase.concurrent;

import ch.javasoft.jbase.Table;
import ch.javasoft.jbase.concurrent.Stateful;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTable<E>
implements Table<E> {
    private final ReadWriteLock rwLock;
    private final Table<E> table;
    private final Thread owner;
    private final ThreadLocal<Table<E>> readTable = new ThreadLocal();

    public <T extends Table<E> & Stateful> ConcurrentTable(T table) throws IOException {
        this(table, Thread.currentThread());
    }

    public <T extends Table<E> & Stateful> ConcurrentTable(T table, Thread owner) throws IOException {
        this.rwLock = new ReentrantReadWriteLock(true);
        this.table = table;
        this.owner = owner;
    }

    protected ReadWriteLock getReadWriteLock() {
        return this.rwLock;
    }

    private Table<E> createReadCopyTable() throws IOException {
        return (Table)((Stateful)((Object)this.table)).createReadCopy(this.rwLock);
    }

    protected Table<E> getReadTable(boolean forceCreate) throws IOException {
        Table<E> readTbl = this.readTable.get();
        if (readTbl == null && forceCreate) {
            Lock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                try {
                    this.table.flush();
                    readTbl = this.createReadCopyTable();
                    this.readTable.set(readTbl);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return readTbl;
    }

    protected boolean isOwner() {
        return this.owner == Thread.currentThread();
    }

    @Override
    public int add(E entity) throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            int n = this.table.add(entity);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close(boolean erase) throws IOException {
        Lock lock;
        if (erase && !this.isOwner()) {
            throw new IOException("erase is only possible for owners of this table");
        }
        Table<E> readTable = this.getReadTable(false);
        if (readTable != null) {
            lock = this.rwLock.readLock();
            lock.lock();
            try {
                readTable.close(false);
            }
            finally {
                lock.unlock();
            }
        }
        if (this.isOwner()) {
            lock = this.rwLock.writeLock();
            lock.lock();
            try {
                this.table.close(erase);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.table.flush();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E get(int index) throws IOException {
        Table<E> readTable = this.getReadTable(true);
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            E e = readTable.get(index);
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeAll() throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.table.removeAll();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void remove(int index) throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.table.remove(index);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void set(int index, E entity) throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.table.set(index, entity);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void swap(int indexA, int indexB) throws IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.table.swap(indexA, indexB);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() throws IOException {
        Table<E> readTable = this.getReadTable(true);
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            int n = readTable.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }
}

