/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataInputInputStream
extends InputStream {
    private final DataInput mDataInput;

    public DataInputInputStream(DataInput in) {
        this.mDataInput = in;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int i = 0;
        while (i < len) {
            try {
                b[off + i] = this.mDataInput.readByte();
            }
            catch (EOFException e) {
                return i == 0 ? -1 : i;
            }
            ++i;
        }
        return len;
    }

    public int read() throws IOException {
        try {
            return this.mDataInput.readUnsignedByte();
        }
        catch (EOFException e) {
            return -1;
        }
    }
}

