/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.CursorType;
import com.amazon.sqlengine.aeprocessor.aetree.AESortSpec;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETCancelState;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.temptable.DataStore;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.temptable.ITemporaryTable;
import com.amazon.sqlengine.executor.etree.temptable.LongDataStore;
import com.amazon.sqlengine.executor.etree.temptable.RowComparator;
import com.amazon.sqlengine.executor.etree.temptable.Sorter;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.Comparator;
import java.util.List;

public class SortedTemporaryTable
implements ITemporaryTable {
    private static final int CHECK_CANCEL_FREQ = 1000;
    private static final long EIGHT_KB = 8192L;
    private DataStore m_dataStore = null;
    private LongDataStore m_longDataStore = null;
    private final List<AESortSpec> m_sortSpecs;
    private final TemporaryTableBuilder.TemporaryTableProperties m_properties;
    private final List<IColumn> m_columnMetadata;
    private final boolean[] m_longDataCol;
    private final RowComparator.NullCollation m_nullCollation;
    private boolean m_moveSuccess = true;
    private boolean[] m_dataNeeded;
    private long m_memAssigned = 0L;
    private final Sorter m_sorter;
    private IMemManagerAgent m_memAgent;
    private long m_rowCount = -1L;
    private final ETCancelState m_cancelState;
    private boolean m_canReopenAfterClosed;
    private boolean m_isOpen = false;

    public SortedTemporaryTable(List<IColumn> list, TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, List<AESortSpec> list2, RowComparator.NullCollation nullCollation, ETCancelState eTCancelState, boolean[] blArray) throws ErrorException {
        this.m_properties = temporaryTableProperties;
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[]{list, temporaryTableProperties, list2, nullCollation});
        }
        this.m_columnMetadata = list;
        this.m_sortSpecs = list2;
        this.m_longDataCol = new boolean[list.size()];
        this.m_nullCollation = nullCollation;
        this.m_dataNeeded = (boolean[])blArray.clone();
        this.m_cancelState = eTCancelState;
        this.prepareForLongDataColumns(this.m_columnMetadata);
        for (AESortSpec aESortSpec : this.m_sortSpecs) {
            if (!this.m_columnMetadata.get(aESortSpec.getColumnNumber()).getTypeMetadata().isBinaryType() && !this.m_longDataCol[aESortSpec.getColumnNumber()]) continue;
            throw SQLEngineExceptionFactory.sortOnLongData(aESortSpec.getColumnNumber() + 1);
        }
        this.m_sorter = new Sorter(this.m_columnMetadata, this.m_sortSpecs, this.m_properties, this.m_nullCollation, eTCancelState, this.m_dataNeeded);
    }

    @Override
    public void close(boolean bl) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (this.m_dataStore != null) {
            this.m_dataStore.destroy();
            this.m_dataStore = null;
        }
        if (this.m_longDataStore != null) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
        this.m_sorter.reset(bl);
        if (!bl) {
            this.m_memAgent.recycleMemory(this.m_memAssigned);
            this.m_memAssigned = 0L;
            this.m_memAgent.unregisterConsumer();
        }
        this.m_rowCount = -1L;
        this.m_isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void open() throws ErrorException {
        this.m_moveSuccess = true;
        this.m_isOpen = true;
    }

    @Override
    public long getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        boolean bl;
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (!this.m_moveSuccess) {
            return false;
        }
        if (null == this.m_dataStore) {
            this.m_moveSuccess = false;
            return false;
        }
        if (1 > this.m_dataStore.numberOfBlocksHeld()) {
            this.m_dataStore.giveBlock();
        }
        if (!(bl = this.m_dataStore.moveToNextRow())) {
            this.m_moveSuccess = false;
        }
        return bl;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (null != this.m_dataStore);
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n, eTDataRequest);
        }
        return DataRetrievalUtil.retrieveFromRowView(n, this.m_longDataCol[n], eTDataRequest, (IRowView)this.m_dataStore, this.m_longDataStore);
    }

    @Override
    public void writeFromRelation(ETRelationalExpr eTRelationalExpr) throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        this.m_canReopenAfterClosed = eTRelationalExpr.canReopenAfterClosed();
        eTRelationalExpr.open(CursorType.FORWARD_ONLY);
        this.m_sorter.initialize();
        this.m_rowCount = 0L;
        while (eTRelationalExpr.move()) {
            ++this.m_rowCount;
            if (this.m_rowCount % 1000L == 0L) {
                this.m_cancelState.checkCancel();
            }
            this.m_sorter.addRow();
            for (int i = 0; i < this.m_columnMetadata.size(); ++i) {
                if (!this.m_dataNeeded[i]) continue;
                if (this.m_longDataCol[i]) {
                    this.m_sorter.setFileMarker(i, this.m_longDataStore.put(i, eTRelationalExpr));
                    continue;
                }
                ETDataRequest eTDataRequest = new ETDataRequest(this.m_columnMetadata.get(i));
                eTRelationalExpr.retrieveData(i, eTDataRequest);
                this.writeFromDataWrapper(this.m_sorter, i, eTDataRequest.getData());
            }
            this.m_sorter.finishAppending();
        }
        this.m_dataStore = this.m_sorter.getSorted(this.m_canReopenAfterClosed);
    }

    public Comparator<IRowView> getRowComparator() {
        return this.m_sorter.getRowComparator();
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memAgent = iMemManagerAgent;
        this.m_sorter.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid amount assigned.");
        }
        long l2 = 0L;
        if (this.m_memAssigned < this.m_properties.m_blockSize) {
            l2 = Math.min(l, this.m_properties.m_blockSize - this.m_memAssigned);
            this.m_memAssigned += l2;
            l -= l2;
        }
        return l2 + this.m_sorter.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_properties.m_blockSize + this.m_sorter.getRequiredMemory() + (this.m_longDataStore == null ? 0L : 8192L);
    }

    @Override
    public void reset() {
        if (-1L == this.m_rowCount) {
            throw new IllegalStateException("Resetting temporary table before data has been set.");
        }
        this.m_moveSuccess = true;
        if (this.m_dataStore != null) {
            this.m_dataStore.reset();
        }
    }

    public void initialize(boolean bl) throws ErrorException {
        this.m_canReopenAfterClosed = bl;
        this.m_sorter.initialize();
        this.m_rowCount = 0L;
        if (this.m_dataStore != null) {
            this.m_dataStore.destroy();
            this.m_dataStore = null;
        }
    }

    public void addRow() throws ErrorException {
        this.m_sorter.addRow();
        ++this.m_rowCount;
    }

    public void writeFromDataWrapper(int n, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
        if (this.m_longDataCol[n]) {
            this.m_sorter.setFileMarker(n, this.m_longDataStore.put(iSqlDataWrapper, this.m_columnMetadata.get(n)));
        } else {
            this.writeFromDataWrapper(this.m_sorter, n, iSqlDataWrapper);
        }
    }

    public void finishAppending() {
        this.m_sorter.finishAppending();
    }

    public void sort() throws ErrorException {
        this.m_dataStore = this.m_sorter.getSorted(this.m_canReopenAfterClosed);
    }

    private void prepareForLongDataColumns(List<IColumn> list) throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, list);
        }
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            IColumn iColumn = list.get(i);
            if (!ColumnSizeCalculator.isLongData(iColumn, this.m_properties.m_maxDataLen)) continue;
            if (!bl) {
                bl = true;
                this.m_longDataStore = new LongDataStore(this.m_properties.m_storageDir, 8192L, this.m_properties.m_logger);
            }
            this.m_longDataCol[i] = true;
        }
    }

    private void writeFromDataWrapper(Sorter sorter, int n, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, sorter, n, iSqlDataWrapper);
        }
        if (iSqlDataWrapper.isNull()) {
            sorter.setNull(n);
            return;
        }
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                sorter.setBigInt(n, iSqlDataWrapper.getBigInt().longValue());
                break;
            }
            case 2: 
            case 3: {
                sorter.setExactNum(n, iSqlDataWrapper.getExactNumber());
                break;
            }
            case 6: 
            case 8: {
                sorter.setDouble(n, iSqlDataWrapper.getDouble());
                break;
            }
            case 7: {
                sorter.setReal(n, iSqlDataWrapper.getReal());
                break;
            }
            case -7: 
            case 16: {
                sorter.setBoolean(n, iSqlDataWrapper.getBoolean());
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                sorter.setString(n, iSqlDataWrapper.getChar());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                sorter.setBytes(n, iSqlDataWrapper.getBinary());
                break;
            }
            case 91: {
                sorter.setDate(n, iSqlDataWrapper.getDate());
                break;
            }
            case 92: {
                sorter.setTime(n, iSqlDataWrapper.getTime());
                break;
            }
            case 93: {
                sorter.setTimestamp(n, iSqlDataWrapper.getTimestamp());
                break;
            }
            case -11: {
                sorter.setGuid(n, iSqlDataWrapper.getGuid());
                break;
            }
            case 4: {
                sorter.setInteger(n, (int)iSqlDataWrapper.getInteger());
                break;
            }
            case 5: {
                sorter.setSmallInt(n, (short)iSqlDataWrapper.getSmallInt());
                break;
            }
            case -6: {
                sorter.setTinyInt(n, (byte)iSqlDataWrapper.getTinyInt());
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + iSqlDataWrapper.getType());
            }
        }
    }
}

