/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.jdbc.common.SCallableStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SDatabaseMetaData;
import com.amazon.jdbc.common.SPreparedStatement;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.jdbc42.JDBC42ObjectFactory;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42CallableStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42DatabaseMetaData;
import com.amazon.redshift.core.jdbc42.PGJDBC42PreparedStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42Statement;
import com.amazon.redshift.core.jdbc42.S42NotifiedConnection;
import com.amazon.support.ILogger;
import java.sql.SQLException;

public class PGJDBC42ObjectFactory
extends JDBC42ObjectFactory {
    protected PGJDBC42ObjectFactory() {
    }

    @Override
    protected SCallableStatement createCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        PGJDBCStatement pGJDBCStatement = (PGJDBCStatement)iStatement;
        pGJDBCStatement.setIsCallableStatement(true);
        return new PGJDBC42CallableStatement(string, pGJDBCStatement, sConnection, n);
    }

    @Override
    protected SConnection createConnection(IConnection iConnection, String string) throws SQLException {
        return new S42NotifiedConnection(iConnection, string);
    }

    @Override
    protected SDatabaseMetaData createDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        IConnection iConnection = null;
        if (sConnection != null) {
            iConnection = sConnection.getDSIConnection();
        }
        return new PGJDBC42DatabaseMetaData(iConnection, sConnection, iLogger);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return new PGJDBC42PreparedStatement(string, iStatement, sConnection, n);
    }

    @Override
    protected SStatement createStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        return new PGJDBC42Statement(iStatement, sConnection, n);
    }
}

