/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.retry;

import com.amazon.redshift.amazonaws.AmazonClientException;
import com.amazon.redshift.amazonaws.AmazonWebServiceRequest;
import com.amazon.redshift.amazonaws.ClientConfiguration;
import com.amazon.redshift.amazonaws.annotation.SdkInternalApi;
import com.amazon.redshift.amazonaws.retry.v2.RetryPolicy;
import com.amazon.redshift.amazonaws.retry.v2.RetryPolicyContext;
import com.amazon.redshift.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final com.amazon.redshift.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(com.amazon.redshift.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public com.amazon.redshift.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

