/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.snapshot;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.jvm.ColumnSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class BigqueryColumnSnapshotGenerator
extends ColumnSnapshotGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column readColumn(CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        Object nullable;
        String rawTableName = (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtil.trimToNull((String)((String)columnMetadataResultSet.get("TABLE_SCHEM")));
        String rawCatalogName = StringUtil.trimToNull((String)((String)columnMetadataResultSet.get("TABLE_CAT")));
        String remarks = StringUtil.trimToNull((String)((String)columnMetadataResultSet.get("REMARKS")));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Integer position = columnMetadataResultSet.getInt("ORDINAL_POSITION");
        Column column = new Column();
        column.setName(StringUtil.trimToNull((String)rawColumnName));
        column.setRelation(table);
        column.setRemarks(remarks);
        column.setOrder(position);
        Boolean isComputed = columnMetadataResultSet.getBoolean("IS_COMPUTED");
        if (isComputed != null) {
            column.setComputed(isComputed);
        }
        if (columnMetadataResultSet.get("IS_FILESTREAM") != null && ((Boolean)columnMetadataResultSet.get("IS_FILESTREAM")).booleanValue()) {
            column.setAttribute("fileStream", (Object)true);
        }
        if (columnMetadataResultSet.get("IS_ROWGUIDCOL") != null && ((Boolean)columnMetadataResultSet.get("IS_ROWGUIDCOL")).booleanValue()) {
            column.setAttribute("rowGuid", (Object)true);
        }
        if (database instanceof OracleDatabase) {
            nullable = columnMetadataResultSet.getString("NULLABLE");
            if ("Y".equals(nullable)) {
                column.setNullable(Boolean.valueOf(true));
            } else {
                column.setNullable(Boolean.valueOf(false));
            }
        } else {
            nullable = columnMetadataResultSet.getInt("NULLABLE");
            if (nullable != null) {
                if ((Integer)nullable == 0) {
                    column.setNullable(Boolean.valueOf(false));
                } else if ((Integer)nullable == 1) {
                    column.setNullable(Boolean.valueOf(true));
                } else if ((Integer)nullable == 2) {
                    column.setNullable(Boolean.valueOf(true));
                }
            }
        }
        if (database.supportsAutoIncrement() && table instanceof Table) {
            if (database instanceof OracleDatabase) {
                Boolean isIdentityColumn;
                Column.AutoIncrementInformation autoIncrementInfo = new Column.AutoIncrementInformation();
                String data_default = StringUtil.trimToEmpty((String)((String)columnMetadataResultSet.get("DATA_DEFAULT"))).toLowerCase();
                if (data_default.contains("iseq$$") && data_default.endsWith("nextval")) {
                    column.setAutoIncrementInformation(autoIncrementInfo);
                }
                if (Boolean.TRUE.equals(isIdentityColumn = columnMetadataResultSet.yesNoToBoolean("IDENTITY_COLUMN"))) {
                    Boolean defaultOnNull = columnMetadataResultSet.yesNoToBoolean("DEFAULT_ON_NULL");
                    String generationType = columnMetadataResultSet.getString("GENERATION_TYPE");
                    autoIncrementInfo.setDefaultOnNull(defaultOnNull);
                    autoIncrementInfo.setGenerationType(generationType);
                    column.setAutoIncrementInformation(autoIncrementInfo);
                }
            } else if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                String isAutoincrement = (String)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if ((isAutoincrement = StringUtil.trimToNull((String)isAutoincrement)) == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.equals("YES")) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else if (isAutoincrement.equals("NO")) {
                    column.setAutoIncrementInformation(null);
                } else {
                    if (!isAutoincrement.equals("")) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Unknown auto increment state for column " + column.toString() + ". Assuming not auto increment");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement;
                if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + rawSchemaName + "." + rawTableName + " where 0=1";
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("rawCatalogName : <" + rawCatalogName + ">");
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("rawSchemaName : <" + rawSchemaName + ">");
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("rawTableName : <" + rawTableName + ">");
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("raw selectStatement : <" + selectStatement + ">");
                } else {
                    selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawTableName) + " where 0=1";
                }
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Checking " + rawTableName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = null;
                ResultSet columnSelectRS = null;
                try {
                    statement = underlyingConnection.createStatement();
                    columnSelectRS = statement.executeQuery(selectStatement);
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                    if (columnSelectRS != null) {
                        columnSelectRS.close();
                    }
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        Object defaultValue = this.readDefaultValue(columnMetadataResultSet, column, database);
        if (defaultValue != null && defaultValue instanceof DatabaseFunction && ((DatabaseFunction)defaultValue).getValue().matches("\\w+")) {
            defaultValue = new DatabaseFunction(((DatabaseFunction)defaultValue).getValue().toUpperCase());
        }
        column.setDefaultValue(defaultValue);
        column.setDefaultValueConstraintName(columnMetadataResultSet.getString("COLUMN_DEF_NAME"));
        return column;
    }
}

