/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.DatasetList;
import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.IFilterableMetadataSource;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BQMetadataSource
implements IFilterableMetadataSource {
    protected static final int CATALOG_FILTER_IDX = 0;
    protected static final int SCHEMA_FILTER_IDX = 1;
    protected static final int TABLE_FILTER_IDX = 2;
    protected static final int COLUMN_FILTER_IDX = 3;
    protected static final int FUNCTION_FILTER_IDX = 4;
    protected final BQMetadataUtils m_bqMetadataUtils;
    protected ErrorException m_cachedException;
    protected final BQConnection m_connection;
    protected IFilter[] m_filters;
    protected final ILogger m_logger;
    protected final Map<MetadataSourceColumnTag, String> m_restrictions;
    protected List<String> m_catalogs = new ArrayList<String>();
    protected List<BQColumnMetadata> m_columns = null;
    protected List<String> m_schemas = null;
    protected List<BQTable> m_tables = null;
    protected List<BQFunction> m_functions = null;
    protected List<BQFunctionColumn> m_functionColumns = null;
    protected int m_catalogIdx = 0;
    protected int m_columnIdx = 0;
    protected int m_schemaIdx = 0;
    protected int m_tableIdx = 0;
    protected int m_functionIdx = 0;
    protected int m_functionColumnIdx = 0;
    protected boolean m_hasStartedCatalogsFetch = false;
    protected boolean m_hasStartedColumnsFetch = false;
    protected boolean m_hasStartedSchemasFetch = false;
    protected boolean m_hasStartedTablesFetch = false;
    protected boolean m_hasStartedFunctionsFetch = false;
    protected boolean m_hasStartedFunctionColumnsFetch = false;
    protected boolean m_haveAllRestrictions = false;

    public BQMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_connection = bQConnection;
        this.m_restrictions = map;
        this.m_bqMetadataUtils = new BQMetadataUtils(iLogger, bQConnection);
    }

    @Override
    public void passdownFilters(List<IFilter> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (IFilter iFilter : list) {
            switch (iFilter.getColumnTag()) {
                case CATALOG_NAME: {
                    this.m_filters[0] = iFilter;
                    break;
                }
                case SCHEMA_NAME: {
                    this.m_filters[1] = iFilter;
                    break;
                }
                case TABLE_NAME: {
                    this.m_filters[2] = iFilter;
                    break;
                }
                case COLUMN_NAME: {
                    this.m_filters[3] = iFilter;
                    break;
                }
                case PROCEDURE_NAME: {
                    this.m_filters[4] = iFilter;
                }
            }
        }
    }

    protected boolean fetchNextSetOfColumns() throws ErrorException {
        String string;
        String string2;
        String string3;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns.clear();
        if (this.m_haveAllRestrictions) {
            string3 = this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
            string2 = this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
            string = this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        } else {
            if (!this.moveToNextTable()) {
                return false;
            }
            string = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME) : this.m_tables.get(this.m_tableIdx).getTableName();
            string2 = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) : this.m_schemas.get(this.m_schemaIdx);
            string3 = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) : this.m_catalogs.get(this.m_catalogIdx);
        }
        this.m_columns = this.m_bqMetadataUtils.getColumns(string3, string2, string);
        if (null != this.m_filters[3] && this.m_columns.size() > 0) {
            ArrayList<BQColumnMetadata> arrayList = new ArrayList<BQColumnMetadata>();
            for (BQColumnMetadata bQColumnMetadata : this.m_columns) {
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.COLUMN_NAME) && bQColumnMetadata.getName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.COLUMN_NAME))) {
                    arrayList.add(bQColumnMetadata);
                    continue;
                }
                if (!this.doesMetadataPassFilter(bQColumnMetadata.getName(), this.m_filters[3])) continue;
                arrayList.add(bQColumnMetadata);
            }
            this.m_columns = arrayList;
        }
        return true;
    }

    protected boolean fetchNextSetOfSchemas() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_schemas.clear();
        if (!this.moveToNextCatalog()) {
            return false;
        }
        List<DatasetList> list = this.m_connection.getClient().getDatasetLists(this.m_catalogs.get(this.m_catalogIdx));
        this.m_schemas = this.m_bqMetadataUtils.convertDatasetsToSchemas(list, this.m_catalogs.get(this.m_catalogIdx));
        if (null != this.m_filters[1] && this.m_schemas.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.m_schemas) {
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) && string.equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME))) {
                    arrayList.add(string);
                    continue;
                }
                if (!this.doesMetadataPassFilter(string, this.m_filters[1])) continue;
                arrayList.add(string);
            }
            this.m_schemas = arrayList;
        }
        return true;
    }

    protected boolean fetchNextSetOfTables() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_tables.clear();
        String string = null;
        String string2 = null;
        if (!this.moveToNextSchema()) {
            return false;
        }
        string = this.m_catalogs.get(this.m_catalogIdx);
        string2 = this.m_schemas.get(this.m_schemaIdx);
        this.m_tables = this.m_bqMetadataUtils.getTables(string, string2, "", "");
        if (null != this.m_filters[2] && this.m_tables.size() > 0) {
            ArrayList<BQTable> arrayList = new ArrayList<BQTable>();
            for (BQTable bQTable : this.m_tables) {
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME) && bQTable.getTableName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME))) {
                    arrayList.add(bQTable);
                    continue;
                }
                if (!this.doesMetadataPassFilter(bQTable.getTableName(), this.m_filters[2])) continue;
                arrayList.add(bQTable);
            }
            this.m_tables = arrayList;
        }
        return true;
    }

    protected boolean fetchNextSetOfFunctions(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_functions.clear();
        String string = null;
        String string2 = null;
        if (!this.moveToNextSchema()) {
            return false;
        }
        string = this.m_catalogs.get(this.m_catalogIdx);
        string2 = this.m_schemas.get(this.m_schemaIdx);
        this.m_functions = this.m_bqMetadataUtils.getFunctions(string, string2, "", bl);
        if (null != this.m_filters[4] && this.m_functions.size() > 0) {
            ArrayList<BQFunction> arrayList = new ArrayList<BQFunction>();
            for (BQFunction bQFunction : this.m_functions) {
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME) && bQFunction.getFunctionName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME))) {
                    arrayList.add(bQFunction);
                    continue;
                }
                if (!this.doesMetadataPassFilter(bQFunction.getFunctionName(), this.m_filters[4])) continue;
                arrayList.add(bQFunction);
            }
            this.m_functions = arrayList;
        }
        return true;
    }

    protected boolean fetchNextSetOfFunctionColumns(boolean bl) throws ErrorException {
        String string;
        String string2;
        String string3;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_functionColumns.clear();
        if (this.m_haveAllRestrictions) {
            string3 = this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
            string2 = this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
            string = this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        } else {
            if (!this.moveToNextFunction(bl)) {
                return false;
            }
            string = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME) : this.m_functions.get(this.m_functionIdx).getFunctionName();
            string2 = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) : this.m_schemas.get(this.m_schemaIdx);
            string3 = null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) ? this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) : this.m_catalogs.get(this.m_catalogIdx);
        }
        this.m_functionColumns = this.m_bqMetadataUtils.getFunctionColumns(string3, string2, string, bl);
        if (null != this.m_filters[3] && this.m_functionColumns.size() > 0) {
            ArrayList<BQFunctionColumn> arrayList = new ArrayList<BQFunctionColumn>();
            for (BQFunctionColumn bQFunctionColumn : this.m_functionColumns) {
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.COLUMN_NAME) && bQFunctionColumn.getName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.COLUMN_NAME))) {
                    arrayList.add(bQFunctionColumn);
                    continue;
                }
                if (!this.doesMetadataPassFilter(bQFunctionColumn.getName(), this.m_filters[3])) continue;
                arrayList.add(bQFunctionColumn);
            }
            this.m_functionColumns = arrayList;
        }
        return true;
    }

    protected boolean moveToNextCatalog() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_catalogs.isEmpty()) {
            this.m_hasStartedCatalogsFetch = true;
            this.m_catalogs = this.m_connection.getClient().getProjects();
            if (null != this.m_filters[0] && this.m_catalogs.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : this.m_catalogs) {
                    if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) && string.equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME))) {
                        arrayList.add(string);
                        continue;
                    }
                    if (null == this.m_filters[0] || !this.doesMetadataPassFilter(string, this.m_filters[0])) continue;
                    arrayList.add(string);
                }
                this.m_catalogIdx = 0;
                this.m_catalogs = arrayList;
            }
        } else {
            ++this.m_catalogIdx;
        }
        return this.m_catalogIdx < this.m_catalogs.size();
    }

    protected boolean moveToNextColumn() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_haveAllRestrictions) {
            if (!this.m_hasStartedColumnsFetch) {
                this.m_columns = new ArrayList<BQColumnMetadata>();
                this.fetchNextSetOfColumns();
                this.m_columnIdx = 0;
                this.m_hasStartedColumnsFetch = true;
            } else {
                ++this.m_columnIdx;
            }
            return this.m_columnIdx != this.m_columns.size();
        }
        if (!this.m_hasStartedColumnsFetch) {
            this.m_columns = new ArrayList<BQColumnMetadata>();
            this.m_columnIdx = 0;
            this.m_hasStartedColumnsFetch = true;
        } else {
            ++this.m_columnIdx;
        }
        while (this.m_columnIdx == this.m_columns.size()) {
            if (!this.fetchNextSetOfColumns()) {
                return false;
            }
            this.m_columnIdx = 0;
        }
        return true;
    }

    protected boolean moveToNextSchema() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedSchemasFetch) {
            this.m_schemas = new ArrayList<String>();
            this.m_schemaIdx = 0;
            this.m_hasStartedSchemasFetch = true;
        } else {
            ++this.m_schemaIdx;
        }
        while (this.m_schemas.isEmpty() || this.m_schemaIdx >= this.m_schemas.size()) {
            if (!this.fetchNextSetOfSchemas()) {
                return false;
            }
            this.m_schemaIdx = 0;
        }
        return true;
    }

    protected boolean moveToNextTable() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_haveAllRestrictions) {
            if (!this.m_hasStartedTablesFetch) {
                this.m_tables = new ArrayList<BQTable>();
                this.m_tableIdx = 0;
                this.fetchNextSetOfTables();
                this.m_hasStartedTablesFetch = true;
            } else {
                ++this.m_tableIdx;
            }
            return this.m_tableIdx < this.m_tables.size();
        }
        if (!this.m_hasStartedTablesFetch) {
            this.m_tables = new ArrayList<BQTable>();
            this.m_tableIdx = 0;
            this.m_hasStartedTablesFetch = true;
        } else {
            ++this.m_tableIdx;
        }
        while (this.m_tables.isEmpty() || this.m_tableIdx >= this.m_tables.size()) {
            if (!this.fetchNextSetOfTables()) {
                return false;
            }
            this.m_tableIdx = 0;
        }
        return true;
    }

    protected boolean moveToNextFunction(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_haveAllRestrictions) {
            if (!this.m_hasStartedFunctionsFetch) {
                this.m_functions = new ArrayList<BQFunction>();
                this.m_functionIdx = 0;
                this.fetchNextSetOfFunctions(bl);
                this.m_hasStartedFunctionsFetch = true;
            } else {
                ++this.m_functionIdx;
            }
            return this.m_functionIdx < this.m_functions.size();
        }
        if (!this.m_hasStartedFunctionsFetch) {
            this.m_functions = new ArrayList<BQFunction>();
            this.m_functionIdx = 0;
            this.m_hasStartedFunctionsFetch = true;
        } else {
            ++this.m_functionIdx;
        }
        while (this.m_functions.isEmpty() || this.m_functionIdx >= this.m_functions.size()) {
            if (!this.fetchNextSetOfFunctions(bl)) {
                return false;
            }
            this.m_functionIdx = 0;
        }
        return true;
    }

    protected boolean moveToNextFunctionColumn(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_haveAllRestrictions) {
            if (!this.m_hasStartedFunctionColumnsFetch) {
                this.m_functionColumns = new ArrayList<BQFunctionColumn>();
                this.m_functionColumnIdx = 0;
                this.fetchNextSetOfFunctionColumns(bl);
                this.m_hasStartedFunctionColumnsFetch = true;
            } else {
                ++this.m_functionColumnIdx;
            }
            return this.m_functionColumnIdx < this.m_functionColumns.size();
        }
        if (!this.m_hasStartedFunctionColumnsFetch) {
            this.m_functionColumns = new ArrayList<BQFunctionColumn>();
            this.m_functionColumnIdx = 0;
            this.m_hasStartedFunctionColumnsFetch = true;
        } else {
            ++this.m_functionColumnIdx;
        }
        while (this.m_functionColumns.isEmpty() || this.m_functionColumnIdx >= this.m_functionColumns.size()) {
            if (!this.fetchNextSetOfFunctionColumns(bl)) {
                return false;
            }
            this.m_functionColumnIdx = 0;
        }
        return true;
    }

    private boolean doesMetadataPassFilter(String string, IFilter iFilter) {
        assert (null != iFilter);
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setVarChar(string);
        return iFilter.filter(dataWrapper);
    }
}

