/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.util.Data;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.dataengine.BQHTParser;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class BQHTDataHandler {
    private BQBufferManager m_bufferManager;
    private final ILogger m_logger;
    private GenericRecord m_row;

    public BQHTDataHandler(BQBufferManager bQBufferManager, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_bufferManager = bQBufferManager;
        this.m_logger = iLogger;
    }

    public boolean moveToNextRow() throws ErrorException {
        this.m_row = this.m_bufferManager.getNextRow();
        if (null == this.m_row) {
            this.m_bufferManager.stop();
            return false;
        }
        return true;
    }

    public boolean retrieveData(int n, BQColumnMetadata bQColumnMetadata, ArrayList<ColumnMetadata> arrayList, long l, long l2, DataWrapper dataWrapper, short s, TypeMetadata typeMetadata) throws ErrorException {
        Object object = null;
        object = this.m_row.get(bQColumnMetadata.getName());
        if (null == object || Data.isNull((Object)object)) {
            dataWrapper.setNull(s);
            return false;
        }
        String string = object.toString();
        if (bQColumnMetadata.isRepeated()) {
            StringBuilder stringBuilder = new StringBuilder();
            string = BQHTParser.avroToString(this.m_logger, object, Schema.Type.ARRAY, stringBuilder, this.m_row.getSchema().getField(bQColumnMetadata.getName()).schema().getElementType().getLogicalType(), null, n, arrayList);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        if (bQColumnMetadata.isRecord()) {
            StringBuilder stringBuilder = new StringBuilder();
            string = BQHTParser.avroToString(this.m_logger, object, Schema.Type.RECORD, stringBuilder, null, null, n, arrayList);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        return BQHTParser.getDataHTAPI(s, typeMetadata, l, l2, dataWrapper, object, this.m_row.getSchema().getField(bQColumnMetadata.getName()), this.m_logger);
    }
}

