![tests](https://github.com/arnedb/tsfuse/workflows/tests/badge.svg)

# TSFuse

Python package for automatically constructing features from multi-view time series data.

## Installation

TSFuse requires Python 3 and the following packages:

- Cython>=0.28.5
- numpy>=1.16.1

These packages can be installed using pip:

    pip install "cython>=0.28.5" "numpy>=1.16.1"
    
To install the latest unreleased version of TSFuse from GitHub:

    pip install git+https://github.com/arnedb/tsfuse#egg=tsfuse
    
## Documentation

The documentation is available on [https://arnedb.github.io/tsfuse/](https://arnedb.github.io/tsfuse/)

Examples on how to use TSFuse are shown in the [getting started](https://arnedb.github.io/tsfuse/getting-started.html) page and the [synthetic sine waves demo](notebooks/Synthetic%20Sine%20Waves%20Demo.ipynb) notebook.

## Paper

To learn more about TSFuse's feature construction method, read the following paper:

> Arne De Brabandere, Pieter Robberechts, Tim Op De Beéck and Jesse Davis. [Automating Feature Construction for Multi-View Time Series Data](https://www.google.com/url?q=https%3A%2F%2Fupvedues-my.sharepoint.com%2F%3Ab%3A%2Fg%2Fpersonal%2Fjorallo_upv_edu_es%2FETxycG2WhmFBmVN7CNW8yKsBQHwhhlzdyegEx1AnNeRa2w%3Fe%3DbPQR7e&sa=D&sntz=1&usg=AFQjCNH-zTIQtPE2M0m0h_uUPN_25SaGCw). ECML/PKDD Workshop on Automating Data Science 2019.
