#!/usr/bin/env python

"""The setup script."""

from setuptools import setup, find_packages


def read_file(filename):
    with open(filename) as fp:
        return fp.read()


requirements = []

setup(
    author="Xero Developer API",
    author_email="api@xero.com",
    python_requires=">=3.5",
    classifiers=[
        "Development Status :: 2 - Pre-Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
    ],
    description="Official Python sdk for Xero API generated by OpenAPI spec for oAuth2",
    install_requires=requirements,
    license="MIT license",
    long_description="\n\n".join((read_file("README.md"), read_file("HISTORY.md"))),
    long_description_content_type="text/markdown",
    include_package_data=True,
    keywords="xero python sdk API oAuth",
    name="xero_python",
    packages=find_packages(include=["xero_python", "xero_python.*"]),
    version="0.1.0",
)
