# coding: utf-8

"""
KnowledgeApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class KnowledgeApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_knowledge_knowledgebase(self, knowledge_base_id, **kwargs):
        """
        Delete knowledge base
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_knowledge_knowledgebase(knowledge_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :return: KnowledgeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_knowledge_knowledgebase" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `delete_knowledge_knowledgebase`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_knowledge_knowledgebase_language_category(self, category_id, knowledge_base_id, language_code, **kwargs):
        """
        Delete category
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_knowledge_knowledgebase_language_category(category_id, knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: Category ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :return: KnowledgeCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id', 'knowledge_base_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_knowledge_knowledgebase_language_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `delete_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `delete_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_knowledge_knowledgebase_language_category`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_knowledge_knowledgebase_language_document(self, document_id, knowledge_base_id, language_code, **kwargs):
        """
        Delete document
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_knowledge_knowledgebase_language_document(document_id, knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :return: KnowledgeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'knowledge_base_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_knowledge_knowledgebase_language_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `delete_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_knowledge_knowledgebase_language_document`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_knowledge_knowledgebase_language_documents_import(self, knowledge_base_id, language_code, import_id, **kwargs):
        """
        Delete import operation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_knowledge_knowledgebase_language_documents_import(knowledge_base_id, language_code, import_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str import_id: Import ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'import_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_knowledge_knowledgebase_language_documents_import" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `delete_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params) or (params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `delete_knowledge_knowledgebase_language_documents_import`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/imports/{importId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']
        if 'import_id' in params:
            path_params['importId'] = params['import_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase(self, knowledge_base_id, **kwargs):
        """
        Get knowledge base
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase(knowledge_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :return: KnowledgeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_categories(self, knowledge_base_id, language_code, **kwargs):
        """
        Get categories
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_categories(knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize, use CursorQueryParameters instead.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str name: Filter to return the categories that starts with the given category name.
        :return: CategoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'before', 'after', 'limit', 'page_size', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_categories" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_categories`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_categories`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CategoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_category(self, category_id, knowledge_base_id, language_code, **kwargs):
        """
        Get category
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_category(category_id, knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: Category ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :return: KnowledgeExtendedCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id', 'knowledge_base_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `get_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_category`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeExtendedCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_document(self, document_id, knowledge_base_id, language_code, **kwargs):
        """
        Get document
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_document(document_id, knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :return: KnowledgeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'knowledge_base_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_document`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_documents(self, knowledge_base_id, language_code, **kwargs):
        """
        Get documents
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_documents(knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize, use CursorQueryParameters instead.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str categories: Filter by categories ids, comma separated values expected.
        :param str title: Filter by document title.
        :param str sort_by: Sort by.
        :param str sort_order: Sort Order.
        :param list[str] document_ids: Comma-separated list of document identifiers to fetch by.
        :return: DocumentListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'before', 'after', 'limit', 'page_size', 'categories', 'title', 'sort_by', 'sort_order', 'document_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_documents`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_documents`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'categories' in params:
            query_params['categories'] = params['categories']
        if 'title' in params:
            query_params['title'] = params['title']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'document_ids' in params:
            query_params['documentIds'] = params['document_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_documents_import(self, knowledge_base_id, language_code, import_id, **kwargs):
        """
        Get import operation report
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_documents_import(knowledge_base_id, language_code, import_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str import_id: Import ID (required)
        :return: KnowledgeImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'import_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_documents_import" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params) or (params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `get_knowledge_knowledgebase_language_documents_import`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/imports/{importId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']
        if 'import_id' in params:
            path_params['importId'] = params['import_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeImport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_training(self, knowledge_base_id, language_code, training_id, **kwargs):
        """
        Get training detail
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_training(knowledge_base_id, language_code, training_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str training_id: Training ID (required)
        :return: KnowledgeTraining
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'training_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_training" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_training`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_training`")
        # verify the required parameter 'training_id' is set
        if ('training_id' not in params) or (params['training_id'] is None):
            raise ValueError("Missing the required parameter `training_id` when calling `get_knowledge_knowledgebase_language_training`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']
        if 'training_id' in params:
            path_params['trainingId'] = params['training_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeTraining',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebase_language_trainings(self, knowledge_base_id, language_code, **kwargs):
        """
        Get all trainings information for a knowledgebase
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebase_language_trainings(knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize, use CursorQueryParameters instead.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str knowledge_documents_state: Return the training with the specified state of the trained documents.
        :return: TrainingListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'before', 'after', 'limit', 'page_size', 'knowledge_documents_state']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebase_language_trainings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `get_knowledge_knowledgebase_language_trainings`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_knowledge_knowledgebase_language_trainings`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'knowledge_documents_state' in params:
            query_params['knowledgeDocumentsState'] = params['knowledge_documents_state']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TrainingListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_knowledge_knowledgebases(self, **kwargs):
        """
        Get knowledge bases
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_knowledge_knowledgebases(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize, use CursorQueryParameters instead.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str name: Filter by Name.
        :param str core_language: Filter by core language.
        :param bool published: Filter by published status.
        :param str sort_by: Sort by.
        :param str sort_order: Sort Order.
        :return: KnowledgeBaseListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'limit', 'page_size', 'name', 'core_language', 'published', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_knowledge_knowledgebases" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/knowledge/knowledgebases'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'core_language' in params:
            query_params['coreLanguage'] = params['core_language']
        if 'published' in params:
            query_params['published'] = params['published']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeBaseListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase(self, knowledge_base_id, body, **kwargs):
        """
        Update knowledge base
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase(knowledge_base_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param KnowledgeBase body:  (required)
        :return: KnowledgeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_knowledge_knowledgebase`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_context(self, knowledge_base_id, context_id, **kwargs):
        """
        Update specific context data of the knowledge base.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_context(knowledge_base_id, context_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID. (required)
        :param str context_id: Context ID. (required)
        :param KnowledgeContextRequest body: 
        :return: KnowledgeContextResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'context_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_context" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_context`")
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `patch_knowledge_knowledgebase_context`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/contexts/{contextId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeContextResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_context_value(self, knowledge_base_id, context_id, context_value_id, **kwargs):
        """
        Update context value.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_context_value(knowledge_base_id, context_id, context_value_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID. (required)
        :param str context_id: Context ID. (required)
        :param str context_value_id: Context Value ID. (required)
        :param KnowledgeContextValueRequest body: 
        :return: KnowledgeContextValueResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'context_id', 'context_value_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_context_value" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_context_value`")
        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `patch_knowledge_knowledgebase_context_value`")
        # verify the required parameter 'context_value_id' is set
        if ('context_value_id' not in params) or (params['context_value_id'] is None):
            raise ValueError("Missing the required parameter `context_value_id` when calling `patch_knowledge_knowledgebase_context_value`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/contexts/{contextId}/values/{contextValueId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'context_id' in params:
            path_params['contextId'] = params['context_id']
        if 'context_value_id' in params:
            path_params['contextValueId'] = params['context_value_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeContextValueResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_language_category(self, category_id, knowledge_base_id, language_code, body, **kwargs):
        """
        Update category
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_language_category(category_id, knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: Category ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param KnowledgeCategoryRequest body:  (required)
        :return: KnowledgeExtendedCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id', 'knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_language_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `patch_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `patch_knowledge_knowledgebase_language_category`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_knowledge_knowledgebase_language_category`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeExtendedCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_language_document(self, document_id, knowledge_base_id, language_code, body, **kwargs):
        """
        Update document
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_language_document(document_id, knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param KnowledgeDocumentRequest body:  (required)
        :return: KnowledgeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_language_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `patch_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `patch_knowledge_knowledgebase_language_document`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_knowledge_knowledgebase_language_document`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_language_documents(self, knowledge_base_id, language_code, body, **kwargs):
        """
        Update documents collection
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_language_documents(knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param list[KnowledgeDocumentBulkRequest] body:  (required)
        :return: DocumentListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_language_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_language_documents`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `patch_knowledge_knowledgebase_language_documents`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_knowledge_knowledgebase_language_documents`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_knowledge_knowledgebase_language_documents_import(self, knowledge_base_id, language_code, import_id, body, **kwargs):
        """
        Start import operation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_knowledge_knowledgebase_language_documents_import(knowledge_base_id, language_code, import_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str import_id: Import ID (required)
        :param ImportStatusRequest body:  (required)
        :return: KnowledgeImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'import_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_knowledge_knowledgebase_language_documents_import" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `patch_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `patch_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'import_id' is set
        if ('import_id' not in params) or (params['import_id'] is None):
            raise ValueError("Missing the required parameter `import_id` when calling `patch_knowledge_knowledgebase_language_documents_import`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_knowledge_knowledgebase_language_documents_import`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/imports/{importId}'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']
        if 'import_id' in params:
            path_params['importId'] = params['import_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeImport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_documentuploads(self, body, **kwargs):
        """
        Creates a presigned URL for uploading a knowledge import file with a set of documents
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_documentuploads(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UploadUrlRequest body: query (required)
        :return: UploadUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_documentuploads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_knowledge_documentuploads`")


        resource_path = '/api/v2/knowledge/documentuploads'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UploadUrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_language_categories(self, knowledge_base_id, language_code, body, **kwargs):
        """
        Create new category
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_language_categories(knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param KnowledgeCategoryRequest body:  (required)
        :return: KnowledgeExtendedCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_language_categories" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_language_categories`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_knowledge_knowledgebase_language_categories`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_knowledge_knowledgebase_language_categories`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeExtendedCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_language_documents(self, knowledge_base_id, language_code, body, **kwargs):
        """
        Create document
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_language_documents(knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param KnowledgeDocumentRequest body:  (required)
        :return: KnowledgeDocument
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_language_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_language_documents`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_knowledge_knowledgebase_language_documents`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_knowledge_knowledgebase_language_documents`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeDocument',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_language_documents_imports(self, knowledge_base_id, language_code, body, **kwargs):
        """
        Create import operation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_language_documents_imports(knowledge_base_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param KnowledgeImport body:  (required)
        :return: KnowledgeImport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_language_documents_imports" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_language_documents_imports`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_knowledge_knowledgebase_language_documents_imports`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_knowledge_knowledgebase_language_documents_imports`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/imports'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeImport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_language_training_promote(self, knowledge_base_id, language_code, training_id, **kwargs):
        """
        Promote trained documents from draft state to active.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_language_training_promote(knowledge_base_id, language_code, training_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :param str training_id: Training ID (required)
        :return: KnowledgeTraining
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code', 'training_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_language_training_promote" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_language_training_promote`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_knowledge_knowledgebase_language_training_promote`")
        # verify the required parameter 'training_id' is set
        if ('training_id' not in params) or (params['training_id'] is None):
            raise ValueError("Missing the required parameter `training_id` when calling `post_knowledge_knowledgebase_language_training_promote`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings/{trainingId}/promote'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']
        if 'training_id' in params:
            path_params['trainingId'] = params['training_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeTraining',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_language_trainings(self, knowledge_base_id, language_code, **kwargs):
        """
        Trigger training
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_language_trainings(knowledge_base_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param str language_code: Language code, format: iso2-LOCALE (required)
        :return: KnowledgeTraining
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_language_trainings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_language_trainings`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_knowledge_knowledgebase_language_trainings`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeTraining',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebase_search(self, knowledge_base_id, **kwargs):
        """
        Search Documents
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebase_search(knowledge_base_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str knowledge_base_id: Knowledge base ID (required)
        :param KnowledgeSearchRequest body: 
        :return: KnowledgeSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['knowledge_base_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebase_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'knowledge_base_id' is set
        if ('knowledge_base_id' not in params) or (params['knowledge_base_id'] is None):
            raise ValueError("Missing the required parameter `knowledge_base_id` when calling `post_knowledge_knowledgebase_search`")


        resource_path = '/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/search'.replace('{format}', 'json')
        path_params = {}
        if 'knowledge_base_id' in params:
            path_params['knowledgeBaseId'] = params['knowledge_base_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_knowledge_knowledgebases(self, body, **kwargs):
        """
        Create new knowledge base
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_knowledge_knowledgebases(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param KnowledgeBase body:  (required)
        :return: KnowledgeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_knowledge_knowledgebases" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_knowledge_knowledgebases`")


        resource_path = '/api/v2/knowledge/knowledgebases'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KnowledgeBase',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
