# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictBool, StrictFloat, StrictInt, StrictStr
from smstools.models.whitelabel_account_response_inbox import WhitelabelAccountResponseInbox

class WhitelabelAccountResponse(BaseModel):
    """
    WhitelabelAccountResponse
    """
    username: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    firstname: Optional[StrictStr] = None
    lastname: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    credits: Optional[Union[StrictFloat, StrictInt]] = None
    language: Optional[StrictStr] = None
    phone: Optional[StrictStr] = None
    mobile: Optional[StrictStr] = None
    address: Optional[StrictStr] = None
    zip: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    vatnumber: Optional[StrictStr] = None
    create_date: Optional[StrictStr] = None
    last_login_utc: Optional[StrictStr] = None
    amount_logins: Optional[StrictInt] = None
    last_sms_date_utc: Optional[StrictStr] = None
    webhooksenabled: Optional[StrictInt] = None
    webhookurl: Optional[StrictStr] = None
    reply_email_active: Optional[StrictBool] = None
    reply_email: Optional[StrictStr] = None
    sender_number: Optional[StrictStr] = None
    whatsapp_number: Optional[StrictStr] = None
    invoice_email: Optional[StrictStr] = None
    invoice_memo: Optional[StrictStr] = None
    invoice_reminder_period: Optional[StrictInt] = None
    creditstype: Optional[StrictStr] = None
    outbound_notifications: Optional[StrictInt] = None
    deliveryurl: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    use: Optional[StrictStr] = None
    inbox: Optional[WhitelabelAccountResponseInbox] = None
    last_sms_date_utc_iso8601: Optional[StrictStr] = None
    __properties = ["username", "email", "firstname", "lastname", "company", "credits", "language", "phone", "mobile", "address", "zip", "city", "country", "vatnumber", "create_date", "last_login_utc", "amount_logins", "last_sms_date_utc", "webhooksenabled", "webhookurl", "reply_email_active", "reply_email", "sender_number", "whatsapp_number", "invoice_email", "invoice_memo", "invoice_reminder_period", "creditstype", "outbound_notifications", "deliveryurl", "currency", "use", "inbox", "last_sms_date_utc_iso8601"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WhitelabelAccountResponse:
        """Create an instance of WhitelabelAccountResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of inbox
        if self.inbox:
            _dict['inbox'] = self.inbox.to_dict()
        # set to None if whatsapp_number (nullable) is None
        # and __fields_set__ contains the field
        if self.whatsapp_number is None and "whatsapp_number" in self.__fields_set__:
            _dict['whatsapp_number'] = None

        # set to None if invoice_email (nullable) is None
        # and __fields_set__ contains the field
        if self.invoice_email is None and "invoice_email" in self.__fields_set__:
            _dict['invoice_email'] = None

        # set to None if invoice_memo (nullable) is None
        # and __fields_set__ contains the field
        if self.invoice_memo is None and "invoice_memo" in self.__fields_set__:
            _dict['invoice_memo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WhitelabelAccountResponse:
        """Create an instance of WhitelabelAccountResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WhitelabelAccountResponse.parse_obj(obj)

        _obj = WhitelabelAccountResponse.parse_obj({
            "username": obj.get("username"),
            "email": obj.get("email"),
            "firstname": obj.get("firstname"),
            "lastname": obj.get("lastname"),
            "company": obj.get("company"),
            "credits": obj.get("credits"),
            "language": obj.get("language"),
            "phone": obj.get("phone"),
            "mobile": obj.get("mobile"),
            "address": obj.get("address"),
            "zip": obj.get("zip"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "vatnumber": obj.get("vatnumber"),
            "create_date": obj.get("create_date"),
            "last_login_utc": obj.get("last_login_utc"),
            "amount_logins": obj.get("amount_logins"),
            "last_sms_date_utc": obj.get("last_sms_date_utc"),
            "webhooksenabled": obj.get("webhooksenabled"),
            "webhookurl": obj.get("webhookurl"),
            "reply_email_active": obj.get("reply_email_active"),
            "reply_email": obj.get("reply_email"),
            "sender_number": obj.get("sender_number"),
            "whatsapp_number": obj.get("whatsapp_number"),
            "invoice_email": obj.get("invoice_email"),
            "invoice_memo": obj.get("invoice_memo"),
            "invoice_reminder_period": obj.get("invoice_reminder_period"),
            "creditstype": obj.get("creditstype"),
            "outbound_notifications": obj.get("outbound_notifications"),
            "deliveryurl": obj.get("deliveryurl"),
            "currency": obj.get("currency"),
            "use": obj.get("use"),
            "inbox": WhitelabelAccountResponseInbox.from_dict(obj.get("inbox")) if obj.get("inbox") is not None else None,
            "last_sms_date_utc_iso8601": obj.get("last_sms_date_utc_iso8601")
        })
        return _obj


