# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from smstools.models.whatsapp_send_action_request_all_of_buttons_inner import WhatsappSendActionRequestAllOfButtonsInner

class WhatsappSendActionRequest(BaseModel):
    """
    WhatsappSendActionRequest
    """
    sender: StrictStr = Field(..., description="The number or name of the sender. A number can't be longer than 14 characters. A name can't be longer than 11 characters and can't contain special characters")
    to: StrictStr = Field(..., description="the number that will receive the message in international format (eg: 324xx, 316xx, ...)")
    var_date: Optional[StrictStr] = Field(None, alias="date", description="Format: yyyy-MM-dd HH:mm. If not provided, the message will be sent as soon as possible")
    reference: Optional[constr(strict=True, max_length=255)] = Field(None, description="String of max. 255 characters")
    test: Optional[StrictBool] = Field(False, description="The system will check all parameters but will not send an SMS message (no credits/balance used).")
    subid: Optional[StrictStr] = Field(None, description="If specified, the message will be sent from the subaccount.")
    buttons: conlist(WhatsappSendActionRequestAllOfButtonsInner) = Field(..., description="Provide an array of objects, where each object contains an id and a title. Both id and title are required fields. Please note: Min amount buttons: 1, Max amount buttons: 3")
    header: Optional[StrictStr] = Field(None, description="The header of the message displayed in WhatsApp.")
    footer: Optional[StrictStr] = Field(None, description="The footer of the message displayed in WhatsApp")
    __properties = ["sender", "to", "date", "reference", "test", "subid", "buttons", "header", "footer"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WhatsappSendActionRequest:
        """Create an instance of WhatsappSendActionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in buttons (list)
        _items = []
        if self.buttons:
            for _item in self.buttons:
                if _item:
                    _items.append(_item.to_dict())
            _dict['buttons'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WhatsappSendActionRequest:
        """Create an instance of WhatsappSendActionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WhatsappSendActionRequest.parse_obj(obj)

        _obj = WhatsappSendActionRequest.parse_obj({
            "sender": obj.get("sender"),
            "to": obj.get("to"),
            "var_date": obj.get("date"),
            "reference": obj.get("reference"),
            "test": obj.get("test") if obj.get("test") is not None else False,
            "subid": obj.get("subid"),
            "buttons": [WhatsappSendActionRequestAllOfButtonsInner.from_dict(_item) for _item in obj.get("buttons")] if obj.get("buttons") is not None else None,
            "header": obj.get("header"),
            "footer": obj.get("footer")
        })
        return _obj


