# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class WhatsappIsWindowOpenRequest(BaseModel):
    """
    WhatsappIsWindowOpenRequest
    """
    to: Optional[StrictStr] = Field(None, description="the number that will receive the message in international format (eg: 324xx, 316xx, ...)")
    sender: StrictStr = Field(..., description="The number or name of the sender. A number can't be longer than 14 characters. A name can't be longer than 11 characters and can't contain special characters")
    __properties = ["to", "sender"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WhatsappIsWindowOpenRequest:
        """Create an instance of WhatsappIsWindowOpenRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WhatsappIsWindowOpenRequest:
        """Create an instance of WhatsappIsWindowOpenRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WhatsappIsWindowOpenRequest.parse_obj(obj)

        _obj = WhatsappIsWindowOpenRequest.parse_obj({
            "to": obj.get("to"),
            "sender": obj.get("sender")
        })
        return _obj


