# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool
from smstools.models.whatsapp_is_window_open200_response_remaining_time import WhatsappIsWindowOpen200ResponseRemainingTime

class WhatsappIsWindowOpen200Response(BaseModel):
    """
    WhatsappIsWindowOpen200Response
    """
    window_open: Optional[StrictBool] = None
    remaining_time: Optional[WhatsappIsWindowOpen200ResponseRemainingTime] = None
    __properties = ["window_open", "remaining_time"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WhatsappIsWindowOpen200Response:
        """Create an instance of WhatsappIsWindowOpen200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of remaining_time
        if self.remaining_time:
            _dict['remaining_time'] = self.remaining_time.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WhatsappIsWindowOpen200Response:
        """Create an instance of WhatsappIsWindowOpen200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return WhatsappIsWindowOpen200Response.parse_obj(obj)

        _obj = WhatsappIsWindowOpen200Response.parse_obj({
            "window_open": obj.get("window_open"),
            "remaining_time": WhatsappIsWindowOpen200ResponseRemainingTime.from_dict(obj.get("remaining_time")) if obj.get("remaining_time") is not None else None
        })
        return _obj


