# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator

class SendVoiceMessageRequest(BaseModel):
    """
    SendVoiceMessageRequest
    """
    message: StrictStr = Field(..., description="the message to be sent")
    to: StrictStr = Field(..., description="the number that will receive the message in international format (eg: 324xx, 316xx, ...)")
    var_date: Optional[StrictStr] = Field(None, alias="date", description="Format: yyyy-MM-dd HH:mm. If not provided, the message will be sent as soon as possible")
    reference: Optional[constr(strict=True, max_length=255)] = Field(None, description="String of max. 255 characters")
    test: Optional[StrictBool] = Field(False, description="The system will check all parameters but will not send an SMS message (no credits/balance used).")
    subid: Optional[StrictStr] = Field(None, description="If specified, the message will be sent from the subaccount.")
    gender: StrictStr = Field(..., description="possible genders: 'Female' (default), 'Male'")
    language: Optional[StrictStr] = Field(None, description="possible languages: en (default), nl, fr or de")
    __properties = ["message", "to", "date", "reference", "test", "subid", "gender", "language"]

    @validator('gender')
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Female', 'Male'):
            raise ValueError("must be one of enum values ('Female', 'Male')")
        return value

    @validator('language')
    def language_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('en', 'nl', 'fr', 'de'):
            raise ValueError("must be one of enum values ('en', 'nl', 'fr', 'de')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendVoiceMessageRequest:
        """Create an instance of SendVoiceMessageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SendVoiceMessageRequest:
        """Create an instance of SendVoiceMessageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SendVoiceMessageRequest.parse_obj(obj)

        _obj = SendVoiceMessageRequest.parse_obj({
            "message": obj.get("message"),
            "to": obj.get("to"),
            "var_date": obj.get("date"),
            "reference": obj.get("reference"),
            "test": obj.get("test") if obj.get("test") is not None else False,
            "subid": obj.get("subid"),
            "gender": obj.get("gender"),
            "language": obj.get("language")
        })
        return _obj


