# coding: utf-8

"""
    Smstools API

    The integration of our SMS gateway is simple. Integrate our SMS API and easily provide your website or software package with text messaging features in minutes.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr

class SendMessageRequest(BaseModel):
    """
    SendMessageRequest
    """
    message: StrictStr = Field(..., description="the message to be sent")
    sender: StrictStr = Field(..., description="The number or name of the sender. A number can't be longer than 14 characters. A name can't be longer than 11 characters and can't contain special characters")
    to: StrictStr = Field(..., description="the number that will receive the message in international format (eg: 324xx, 316xx, ...)")
    var_date: Optional[StrictStr] = Field(None, alias="date", description="Format: yyyy-MM-dd HH:mm. If not provided, the message will be sent as soon as possible")
    reference: Optional[constr(strict=True, max_length=255)] = Field(None, description="String of max. 255 characters")
    test: Optional[StrictBool] = Field(False, description="The system will check all parameters but will not send an SMS message (no credits/balance used).")
    subid: Optional[StrictStr] = Field(None, description="If specified, the message will be sent from the subaccount.")
    __properties = ["message", "sender", "to", "date", "reference", "test", "subid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SendMessageRequest:
        """Create an instance of SendMessageRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SendMessageRequest:
        """Create an instance of SendMessageRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SendMessageRequest.parse_obj(obj)

        _obj = SendMessageRequest.parse_obj({
            "message": obj.get("message"),
            "sender": obj.get("sender"),
            "to": obj.get("to"),
            "var_date": obj.get("date"),
            "reference": obj.get("reference"),
            "test": obj.get("test") if obj.get("test") is not None else False,
            "subid": obj.get("subid")
        })
        return _obj


