# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr

class GetWebhook200ResponseInnerMessage(BaseModel):
    """
    GetWebhook200ResponseInnerMessage
    """
    messageid: Optional[StrictStr] = None
    datetime: Optional[StrictStr] = None
    content: Optional[StrictStr] = None
    sender: Optional[StrictStr] = None
    receiver: Optional[StrictStr] = None
    reference: Optional[StrictStr] = None
    delivery_code: Optional[StrictStr] = None
    delivery_status: Optional[StrictStr] = None
    delivery_code_detail: Optional[StrictStr] = None
    delivery_code_detail_description: Optional[StrictStr] = None
    __properties = ["messageid", "datetime", "content", "sender", "receiver", "reference", "delivery_code", "delivery_status", "delivery_code_detail", "delivery_code_detail_description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetWebhook200ResponseInnerMessage:
        """Create an instance of GetWebhook200ResponseInnerMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetWebhook200ResponseInnerMessage:
        """Create an instance of GetWebhook200ResponseInnerMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetWebhook200ResponseInnerMessage.parse_obj(obj)

        _obj = GetWebhook200ResponseInnerMessage.parse_obj({
            "messageid": obj.get("messageid"),
            "datetime": obj.get("datetime"),
            "content": obj.get("content"),
            "sender": obj.get("sender"),
            "receiver": obj.get("receiver"),
            "reference": obj.get("reference"),
            "delivery_code": obj.get("delivery_code"),
            "delivery_status": obj.get("delivery_status"),
            "delivery_code_detail": obj.get("delivery_code_detail"),
            "delivery_code_detail_description": obj.get("delivery_code_detail_description")
        })
        return _obj


