# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictInt, conlist
from smstools.models.message_response import MessageResponse

class GetOutbox200Response(BaseModel):
    """
    GetOutbox200Response
    """
    total: Optional[StrictInt] = None
    shown: Optional[StrictInt] = None
    page: Optional[StrictInt] = None
    limit: Optional[StrictInt] = None
    messages: Optional[conlist(MessageResponse)] = None
    __properties = ["total", "shown", "page", "limit", "messages"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetOutbox200Response:
        """Create an instance of GetOutbox200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['messages'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetOutbox200Response:
        """Create an instance of GetOutbox200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetOutbox200Response.parse_obj(obj)

        _obj = GetOutbox200Response.parse_obj({
            "total": obj.get("total"),
            "shown": obj.get("shown"),
            "page": obj.get("page"),
            "limit": obj.get("limit"),
            "messages": [MessageResponse.from_dict(_item) for _item in obj.get("messages")] if obj.get("messages") is not None else None
        })
        return _obj


