# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from smstools.models.get_conversation200_response_all_of_conversation_inner_file import GetConversation200ResponseAllOfConversationInnerFile

class GetConversation200ResponseAllOfConversationInner(BaseModel):
    """
    GetConversation200ResponseAllOfConversationInner
    """
    message_id: Optional[StrictStr] = Field(None, alias="messageId")
    direction: Optional[StrictStr] = None
    sender: Optional[StrictStr] = None
    receiver: Optional[StrictStr] = None
    message: Optional[StrictStr] = None
    file: Optional[GetConversation200ResponseAllOfConversationInnerFile] = None
    datetime: Optional[StrictStr] = None
    unix_datetime: Optional[StrictInt] = Field(None, alias="unixDatetime")
    delivery_status: Optional[StrictStr] = Field(None, alias="deliveryStatus")
    mine: Optional[StrictBool] = None
    __properties = ["messageId", "direction", "sender", "receiver", "message", "file", "datetime", "unixDatetime", "deliveryStatus", "mine"]

    @validator('direction')
    def direction_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('inbound', 'outbound'):
            raise ValueError("must be one of enum values ('inbound', 'outbound')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetConversation200ResponseAllOfConversationInner:
        """Create an instance of GetConversation200ResponseAllOfConversationInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # set to None if file (nullable) is None
        # and __fields_set__ contains the field
        if self.file is None and "file" in self.__fields_set__:
            _dict['file'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetConversation200ResponseAllOfConversationInner:
        """Create an instance of GetConversation200ResponseAllOfConversationInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetConversation200ResponseAllOfConversationInner.parse_obj(obj)

        _obj = GetConversation200ResponseAllOfConversationInner.parse_obj({
            "message_id": obj.get("messageId"),
            "direction": obj.get("direction"),
            "sender": obj.get("sender"),
            "receiver": obj.get("receiver"),
            "message": obj.get("message"),
            "file": GetConversation200ResponseAllOfConversationInnerFile.from_dict(obj.get("file")) if obj.get("file") is not None else None,
            "datetime": obj.get("datetime"),
            "unix_datetime": obj.get("unixDatetime"),
            "delivery_status": obj.get("deliveryStatus"),
            "mine": obj.get("mine")
        })
        return _obj


