# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ContactInfoResponse(BaseModel):
    """
    ContactInfoResponse
    """
    id: StrictStr = Field(..., alias="ID")
    phone: StrictStr = Field(...)
    firstname: Optional[StrictStr] = None
    lastname: Optional[StrictStr] = None
    unsubscribed: Optional[StrictBool] = None
    groupid: StrictStr = Field(...)
    email: Optional[StrictStr] = None
    extra1: Optional[StrictStr] = None
    extra2: Optional[StrictStr] = None
    extra3: Optional[StrictStr] = None
    extra4: Optional[StrictStr] = None
    extra5: Optional[StrictStr] = None
    extra6: Optional[StrictStr] = None
    extra7: Optional[StrictStr] = None
    extra8: Optional[StrictStr] = None
    extra9: Optional[StrictStr] = None
    extra10: Optional[StrictStr] = None
    birthday: Optional[StrictStr] = None
    memo: Optional[StrictStr] = None
    __properties = ["ID", "phone", "firstname", "lastname", "unsubscribed", "groupid", "email", "extra1", "extra2", "extra3", "extra4", "extra5", "extra6", "extra7", "extra8", "extra9", "extra10", "birthday", "memo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContactInfoResponse:
        """Create an instance of ContactInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if extra9 (nullable) is None
        # and __fields_set__ contains the field
        if self.extra9 is None and "extra9" in self.__fields_set__:
            _dict['extra9'] = None

        # set to None if extra10 (nullable) is None
        # and __fields_set__ contains the field
        if self.extra10 is None and "extra10" in self.__fields_set__:
            _dict['extra10'] = None

        # set to None if birthday (nullable) is None
        # and __fields_set__ contains the field
        if self.birthday is None and "birthday" in self.__fields_set__:
            _dict['birthday'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContactInfoResponse:
        """Create an instance of ContactInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContactInfoResponse.parse_obj(obj)

        _obj = ContactInfoResponse.parse_obj({
            "id": obj.get("ID"),
            "phone": obj.get("phone"),
            "firstname": obj.get("firstname"),
            "lastname": obj.get("lastname"),
            "unsubscribed": obj.get("unsubscribed"),
            "groupid": obj.get("groupid"),
            "email": obj.get("email"),
            "extra1": obj.get("extra1"),
            "extra2": obj.get("extra2"),
            "extra3": obj.get("extra3"),
            "extra4": obj.get("extra4"),
            "extra5": obj.get("extra5"),
            "extra6": obj.get("extra6"),
            "extra7": obj.get("extra7"),
            "extra8": obj.get("extra8"),
            "extra9": obj.get("extra9"),
            "extra10": obj.get("extra10"),
            "birthday": obj.get("birthday"),
            "memo": obj.get("memo")
        })
        return _obj


