# coding: utf-8

"""
    Smstools API

    The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr

class AccountResponse(BaseModel):
    """
    AccountResponse
    """
    username: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    firstname: Optional[StrictStr] = None
    lastname: Optional[StrictStr] = None
    company: Optional[StrictStr] = None
    credits: Optional[Union[StrictFloat, StrictInt]] = None
    language: Optional[StrictStr] = None
    phone: Optional[StrictStr] = None
    mobile: Optional[StrictStr] = None
    address: Optional[StrictStr] = None
    zip: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    vatnumber: Optional[StrictStr] = None
    webhooksenabled: Optional[StrictInt] = None
    webhookurl: Optional[StrictStr] = None
    creditstype: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    use: Optional[StrictStr] = None
    __properties = ["username", "email", "firstname", "lastname", "company", "credits", "language", "phone", "mobile", "address", "zip", "city", "country", "vatnumber", "webhooksenabled", "webhookurl", "creditstype", "currency", "use"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountResponse:
        """Create an instance of AccountResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountResponse:
        """Create an instance of AccountResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountResponse.parse_obj(obj)

        _obj = AccountResponse.parse_obj({
            "username": obj.get("username"),
            "email": obj.get("email"),
            "firstname": obj.get("firstname"),
            "lastname": obj.get("lastname"),
            "company": obj.get("company"),
            "credits": obj.get("credits"),
            "language": obj.get("language"),
            "phone": obj.get("phone"),
            "mobile": obj.get("mobile"),
            "address": obj.get("address"),
            "zip": obj.get("zip"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "vatnumber": obj.get("vatnumber"),
            "webhooksenabled": obj.get("webhooksenabled"),
            "webhookurl": obj.get("webhookurl"),
            "creditstype": obj.get("creditstype"),
            "currency": obj.get("currency"),
            "use": obj.get("use")
        })
        return _obj


