# smstools
The SMS Gateway API for smstools provides a robust and easy-to-integrate solution for sending and receiving SMS messages programmatically. It enables developers to integrate text messaging capabilities into their applications, websites, and software, offering features such as sending single or bulk SMS, managing contacts and groups, receiving inbound messages, and accessing delivery reports. This API facilitates various communication needs, from marketing campaigns to CRM integrations and automated alerts. Please note that this API description is independently created and not affiliated with smstools.com. Official documentation at: https://www.smstools.com/en/sms-gateway-api/

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import smstools
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import smstools
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from pprint import pprint

from smstools import Smstools, ApiException


if __name__ == '__main__':
    smstools_client = Smstools(
        client_id="CLIENT_ID",
        client_secret="CLIENT_SECRET",
    )

    try:
        response = smstools_client.get_account()
        pprint(response.to_dict())
    except ApiException as e:
        print("Exception when calling smstools API: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.smsgatewayapi.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_contact**](docs/DefaultApi.md#create_contact) | **POST** /v1/contact | Add contact
*DefaultApi* | [**create_group**](docs/DefaultApi.md#create_group) | **POST** /v1/groups | Add group
*DefaultApi* | [**create_message_template**](docs/DefaultApi.md#create_message_template) | **POST** /v1/messagetemplates | Add message template
*DefaultApi* | [**create_optout**](docs/DefaultApi.md#create_optout) | **POST** /v1/optouts | Add Opt-out
*DefaultApi* | [**create_subaccount**](docs/DefaultApi.md#create_subaccount) | **POST** /v1/subaccount | Create subaccount | teammate
*DefaultApi* | [**format_number**](docs/DefaultApi.md#format_number) | **POST** /v1/format/number | Format number
*DefaultApi* | [**get_account**](docs/DefaultApi.md#get_account) | **GET** /v1/account | Get account
*DefaultApi* | [**get_balance**](docs/DefaultApi.md#get_balance) | **GET** /v1/balance | Get balance
*DefaultApi* | [**get_conversation**](docs/DefaultApi.md#get_conversation) | **GET** /v1/conversation/{phone} | Get a conversation with a number.
*DefaultApi* | [**get_country_codes**](docs/DefaultApi.md#get_country_codes) | **GET** /v1/countrycodes/{language} | Get country codes
*DefaultApi* | [**get_group**](docs/DefaultApi.md#get_group) | **GET** /v1/groups/{id} | Get group
*DefaultApi* | [**get_history**](docs/DefaultApi.md#get_history) | **GET** /v1/message/logging | Get history
*DefaultApi* | [**get_inbox**](docs/DefaultApi.md#get_inbox) | **GET** /v1/message/inbox | Get inbox
*DefaultApi* | [**get_message_template**](docs/DefaultApi.md#get_message_template) | **GET** /v1/messagetemplates/{id} | Get specific message template
*DefaultApi* | [**get_outbox**](docs/DefaultApi.md#get_outbox) | **GET** /v1/outbox | Get outbox
*DefaultApi* | [**get_sender_id**](docs/DefaultApi.md#get_sender_id) | **GET** /v1/senderids | Get sender ID
*DefaultApi* | [**get_specific_inbox**](docs/DefaultApi.md#get_specific_inbox) | **GET** /v1/message/inbox/{id} | Get specific inbox
*DefaultApi* | [**get_subaccount**](docs/DefaultApi.md#get_subaccount) | **GET** /v1/subaccount/{id} | Get subaccount | teammate
*DefaultApi* | [**get_subaccount_history**](docs/DefaultApi.md#get_subaccount_history) | **GET** /v1/message/logging/subaccount/{id} | Get History subaccount | teammate
*DefaultApi* | [**get_webhook**](docs/DefaultApi.md#get_webhook) | **GET** /v1/webhook/{id} | Get webhook
*DefaultApi* | [**get_whitelabel_account**](docs/DefaultApi.md#get_whitelabel_account) | **GET** /v1/customer/{accountName} | Get whitelabel account
*DefaultApi* | [**get_whitelabel_account_sso**](docs/DefaultApi.md#get_whitelabel_account_sso) | **GET** /v1/customer/{accountName}/login | Get whitelabel account SSO
*DefaultApi* | [**list_contacts**](docs/DefaultApi.md#list_contacts) | **GET** /v1/contact | Get all contacts
*DefaultApi* | [**list_groups**](docs/DefaultApi.md#list_groups) | **GET** /v1/groups | Get all groups
*DefaultApi* | [**list_message_templates**](docs/DefaultApi.md#list_message_templates) | **GET** /v1/messagetemplates | Get message templates
*DefaultApi* | [**list_optouts**](docs/DefaultApi.md#list_optouts) | **GET** /v1/optouts/list | List Opt-out
*DefaultApi* | [**list_statistics**](docs/DefaultApi.md#list_statistics) | **GET** /v1/statistics | Get statistics
*DefaultApi* | [**list_subaccount_statistics**](docs/DefaultApi.md#list_subaccount_statistics) | **GET** /v1/statistics/subaccount/{id} | Get statistics subaccount | teammate
*DefaultApi* | [**list_subaccounts**](docs/DefaultApi.md#list_subaccounts) | **GET** /v1/subaccount | List subaccounts | teammates
*DefaultApi* | [**list_virtual_mobile_numbers**](docs/DefaultApi.md#list_virtual_mobile_numbers) | **GET** /v1/vmn | Get virtual mobile numbers
*DefaultApi* | [**list_whitelabel_accounts**](docs/DefaultApi.md#list_whitelabel_accounts) | **GET** /v1/customer | List whitelabel accounts
*DefaultApi* | [**remove_contact**](docs/DefaultApi.md#remove_contact) | **DELETE** /v1/contact/{id} | Remove contact
*DefaultApi* | [**remove_from_outbox**](docs/DefaultApi.md#remove_from_outbox) | **DELETE** /v1/outbox/{id} | Remove from outbox
*DefaultApi* | [**remove_group**](docs/DefaultApi.md#remove_group) | **DELETE** /v1/groups/{id} | Remove group
*DefaultApi* | [**remove_message_template**](docs/DefaultApi.md#remove_message_template) | **DELETE** /v1/messagetemplates/{id} | Remove message template
*DefaultApi* | [**remove_optout**](docs/DefaultApi.md#remove_optout) | **DELETE** /v1/optouts/{phone} | Remove Opt-out
*DefaultApi* | [**search_contact**](docs/DefaultApi.md#search_contact) | **GET** /v1/contact/search/{keyword} | Search contact
*DefaultApi* | [**send_text_message**](docs/DefaultApi.md#send_text_message) | **POST** /v1/message/send | Send text message
*DefaultApi* | [**send_voice_message**](docs/DefaultApi.md#send_voice_message) | **POST** /v1/voice/send | Send voice message
*DefaultApi* | [**update_contact**](docs/DefaultApi.md#update_contact) | **PATCH** /v1/contact | Update contact
*DefaultApi* | [**update_group**](docs/DefaultApi.md#update_group) | **PATCH** /v1/groups | Update group
*DefaultApi* | [**update_message_template**](docs/DefaultApi.md#update_message_template) | **PATCH** /v1/messagetemplates | Update message template
*DefaultApi* | [**update_subaccount**](docs/DefaultApi.md#update_subaccount) | **PATCH** /v1/subaccount/{id} | Update subaccount | teammate
*DefaultApi* | [**whatsapp_is_window_open**](docs/DefaultApi.md#whatsapp_is_window_open) | **POST** /v1/whatsapp/is_window_open | is 24H window open
*DefaultApi* | [**whatsapp_list_numbers**](docs/DefaultApi.md#whatsapp_list_numbers) | **GET** /v1/whatsapp/numbers | Get account numbers
*DefaultApi* | [**whatsapp_list_templates**](docs/DefaultApi.md#whatsapp_list_templates) | **GET** /v1/whatsapp/templates | Get account templates
*DefaultApi* | [**whatsapp_send_action**](docs/DefaultApi.md#whatsapp_send_action) | **POST** /v1/whatsapp/send_action | Send Action
*DefaultApi* | [**whatsapp_send_file**](docs/DefaultApi.md#whatsapp_send_file) | **POST** /v1/whatsapp/send_file | Send File
*DefaultApi* | [**whatsapp_send_list**](docs/DefaultApi.md#whatsapp_send_list) | **POST** /v1/whatsapp/send_list | Send List
*DefaultApi* | [**whatsapp_send_location**](docs/DefaultApi.md#whatsapp_send_location) | **POST** /v1/whatsapp/send_location | Send Location
*DefaultApi* | [**whatsapp_send_template**](docs/DefaultApi.md#whatsapp_send_template) | **POST** /v1/whatsapp/send_template | Send Template
*DefaultApi* | [**whatsapp_send_text**](docs/DefaultApi.md#whatsapp_send_text) | **POST** /v1/whatsapp/send_text | Send Text


## Documentation For Models

 - [AccountResponse](docs/AccountResponse.md)
 - [BalanceResponse](docs/BalanceResponse.md)
 - [ContactInfoCreateRequest](docs/ContactInfoCreateRequest.md)
 - [ContactInfoResponse](docs/ContactInfoResponse.md)
 - [ContactInfoUpdateRequest](docs/ContactInfoUpdateRequest.md)
 - [CreateMessageTemplateRequest](docs/CreateMessageTemplateRequest.md)
 - [CreateOptoutRequest](docs/CreateOptoutRequest.md)
 - [CreateSubaccountRequest](docs/CreateSubaccountRequest.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FormatNumber200Response](docs/FormatNumber200Response.md)
 - [FormatNumberRequest](docs/FormatNumberRequest.md)
 - [GetConversation200Response](docs/GetConversation200Response.md)
 - [GetConversation200ResponseAllOfConversationInner](docs/GetConversation200ResponseAllOfConversationInner.md)
 - [GetConversation200ResponseAllOfConversationInnerFile](docs/GetConversation200ResponseAllOfConversationInnerFile.md)
 - [GetCountryCodes200ResponseInner](docs/GetCountryCodes200ResponseInner.md)
 - [GetGroup200Response](docs/GetGroup200Response.md)
 - [GetHistory200Response](docs/GetHistory200Response.md)
 - [GetHistory200ResponseAllOfMessagesInner](docs/GetHistory200ResponseAllOfMessagesInner.md)
 - [GetHistory200ResponseAllOfMessagesInnerResponse](docs/GetHistory200ResponseAllOfMessagesInnerResponse.md)
 - [GetInbox200Response](docs/GetInbox200Response.md)
 - [GetInbox200ResponseAllOfMessagesInner](docs/GetInbox200ResponseAllOfMessagesInner.md)
 - [GetOutbox200Response](docs/GetOutbox200Response.md)
 - [GetSpecificInbox200Response](docs/GetSpecificInbox200Response.md)
 - [GetSpecificInbox200ResponseAllOfMessagesInner](docs/GetSpecificInbox200ResponseAllOfMessagesInner.md)
 - [GetWebhook200ResponseInner](docs/GetWebhook200ResponseInner.md)
 - [GetWebhook200ResponseInnerMessage](docs/GetWebhook200ResponseInnerMessage.md)
 - [GetWhitelabelAccountSSO200Response](docs/GetWhitelabelAccountSSO200Response.md)
 - [GroupInfoCreateRequest](docs/GroupInfoCreateRequest.md)
 - [GroupInfoResponse](docs/GroupInfoResponse.md)
 - [GroupInfoUpdateRequest](docs/GroupInfoUpdateRequest.md)
 - [IdsResponse](docs/IdsResponse.md)
 - [ListContacts200Response](docs/ListContacts200Response.md)
 - [ListStatistics200Response](docs/ListStatistics200Response.md)
 - [ListVirtualMobileNumbers200ResponseInner](docs/ListVirtualMobileNumbers200ResponseInner.md)
 - [ListWhitelabelAccounts200Response](docs/ListWhitelabelAccounts200Response.md)
 - [MessageParameter](docs/MessageParameter.md)
 - [MessageResponse](docs/MessageResponse.md)
 - [MessageTemplateResponse](docs/MessageTemplateResponse.md)
 - [OptoutResponse](docs/OptoutResponse.md)
 - [PaginationResponse](docs/PaginationResponse.md)
 - [SendParameters](docs/SendParameters.md)
 - [SendResponse](docs/SendResponse.md)
 - [SendTextMessageRequest](docs/SendTextMessageRequest.md)
 - [SendVoiceMessageRequest](docs/SendVoiceMessageRequest.md)
 - [SenderIdResponse](docs/SenderIdResponse.md)
 - [SenderParameter](docs/SenderParameter.md)
 - [SubaccountResponse](docs/SubaccountResponse.md)
 - [ToParameter](docs/ToParameter.md)
 - [UpdateMessageTemplateRequest](docs/UpdateMessageTemplateRequest.md)
 - [UpdateSubaccountRequest](docs/UpdateSubaccountRequest.md)
 - [WhatsappIsWindowOpen200Response](docs/WhatsappIsWindowOpen200Response.md)
 - [WhatsappIsWindowOpen200ResponseRemainingTime](docs/WhatsappIsWindowOpen200ResponseRemainingTime.md)
 - [WhatsappIsWindowOpenRequest](docs/WhatsappIsWindowOpenRequest.md)
 - [WhatsappListNumbers200Response](docs/WhatsappListNumbers200Response.md)
 - [WhatsappListNumbers200ResponseNumbersInner](docs/WhatsappListNumbers200ResponseNumbersInner.md)
 - [WhatsappListTemplates200Response](docs/WhatsappListTemplates200Response.md)
 - [WhatsappListTemplates200ResponseTemplatesInner](docs/WhatsappListTemplates200ResponseTemplatesInner.md)
 - [WhatsappSendActionRequest](docs/WhatsappSendActionRequest.md)
 - [WhatsappSendActionRequestAllOfButtonsInner](docs/WhatsappSendActionRequestAllOfButtonsInner.md)
 - [WhatsappSendFileRequest](docs/WhatsappSendFileRequest.md)
 - [WhatsappSendListRequest](docs/WhatsappSendListRequest.md)
 - [WhatsappSendLocationRequest](docs/WhatsappSendLocationRequest.md)
 - [WhatsappSendLocationRequestAllOfLocation](docs/WhatsappSendLocationRequestAllOfLocation.md)
 - [WhatsappSendTemplateRequest](docs/WhatsappSendTemplateRequest.md)
 - [WhitelabelAccountResponse](docs/WhitelabelAccountResponse.md)
 - [WhitelabelAccountResponseInbox](docs/WhitelabelAccountResponseInbox.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="clientId"></a>
### clientId

- **Type**: API key
- **API key parameter name**: X-Client-Id
- **Location**: HTTP header

<a id="clientSecret"></a>
### clientSecret

- **Type**: API key
- **API key parameter name**: X-Client-Secret
- **Location**: HTTP header


## Author




