window.djeymYMaps.modules.define("util.calculateArea",[],(function(provide){var RADIUS=6378137;function calculateArea(feature){var geoJsonGeometry;return calculateJsonGeometryArea(getGeoJsonGeometry(feature))}function getGeoJsonGeometry(feature){if("Feature"===feature.type)return feature.geometry;if(feature.geometry&&feature.geometry.getType)return"Circle"===feature.geometry.getType()?{type:"Circle",coordinates:feature.geometry.getCoordinates(),radius:feature.geometry.getRadius()}:{type:feature.geometry.getType(),coordinates:feature.geometry.getCoordinates()};throw new Error("util.calculateArea: Unknown input object.")}function calculateJsonGeometryArea(geometry){var area=0,i;switch(geometry.type){case"Polygon":return polygonArea(geometry.coordinates);case"MultiPolygon":for(i=0;i<geometry.coordinates.length;i++)area+=polygonArea(geometry.coordinates[i]);return area;case"Rectangle":return polygonArea([[geometry.coordinates[0],[geometry.coordinates[0][0],geometry.coordinates[1][1]],geometry.coordinates[1],[geometry.coordinates[1][0],geometry.coordinates[0][1]],geometry.coordinates[0]]]);case"Circle":return Math.PI*Math.pow(geometry.radius,2);case"Point":case"MultiPoint":case"LineString":case"MultiLineString":return 0}}function polygonArea(coords){var area=0;if(coords&&coords.length>0){area+=Math.abs(ringArea(coords[0]));for(var i=1;i<coords.length;i++)area-=Math.abs(ringArea(coords[i]))}return area}function ringArea(coords){var p1,p2,p3,lowerIndex,middleIndex,upperIndex,i,area=0,coordsLength=coords.length,longitude="latlong"===window.djeymYMaps.meta.coordinatesOrder?1:0,latitude="latlong"===window.djeymYMaps.meta.coordinatesOrder?0:1;if(coordsLength>2){for(i=0;i<coordsLength;i++)i===coordsLength-2?(lowerIndex=coordsLength-2,middleIndex=coordsLength-1,upperIndex=0):i===coordsLength-1?(lowerIndex=coordsLength-1,middleIndex=0,upperIndex=1):(lowerIndex=i,middleIndex=i+1,upperIndex=i+2),p1=coords[lowerIndex],p2=coords[middleIndex],area+=(rad((p3=coords[upperIndex])[longitude])-rad(p1[longitude]))*Math.sin(rad(p2[latitude]));area=area*RADIUS*RADIUS/2}return area}function rad(_){return _*Math.PI/180}provide(calculateArea)}));