# Generated by Django 3.0.2 on 2020-01-27 05:58

import adminsortable.fields
import ckeditor_uploader.fields
import colorful.fields
from decimal import Decimal
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import djeym.utils


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BlockedIP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip', models.GenericIPAddressField(null=True, unique=True, verbose_name='IP-address')),
                ('timestamp', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Date and Time')),
            ],
            options={
                'verbose_name': 'Blocked IP',
                'verbose_name_plural': 'Blocked IPs',
            },
        ),
        migrations.CreateModel(
            name='CategoryPlacemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Name of any geographic area - Country Name or City Name or District Name or The name of the resort coast, etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#00C853', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
            ],
            options={
                'verbose_name': '-Category of marker',
                'verbose_name_plural': '-Category of markers',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='ClusterIcon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('svg', models.FileField(help_text='Only SVG files.', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_svg], verbose_name='Icon')),
                ('title', models.CharField(default='', help_text='Example: Green Garden', max_length=60, unique=True, verbose_name='Cluster name')),
                ('size_width', models.PositiveSmallIntegerField(default=0, verbose_name='Icon width')),
                ('size_height', models.PositiveSmallIntegerField(default=0, verbose_name='Icon height')),
                ('offset_x', models.DecimalField(decimal_places=1, default=Decimal('0.0'), max_digits=3, verbose_name='Offset by axis - X')),
                ('offset_y', models.DecimalField(decimal_places=1, default=Decimal('0.0'), max_digits=3, verbose_name='Offset by axis - Y')),
            ],
            options={
                'verbose_name': 'Icons for clusters',
                'verbose_name_plural': 'Icons for clusters',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='IconCollection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', help_text='Example: Сherry Light Amber', max_length=60, unique=True, verbose_name='Collection name')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Icon collections for markers',
                'verbose_name_plural': 'Icon collections for markers',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='LoadIndicator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('svg', models.FileField(null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_svg], verbose_name='Icon')),
                ('title', models.CharField(default='', max_length=60, unique=True, verbose_name='Title')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True)),
            ],
            options={
                'verbose_name': 'Load indicator',
                'verbose_name_plural': 'Load indicators',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='Map',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Examples: Supermarkets of the city of Kharkov or Hawaii - Oahu Island or Luxury hotels in Honolulu or Parking of primitive people, etc.', max_length=60, unique=True, verbose_name='Title')),
                ('load_indicator_size', models.PositiveSmallIntegerField(choices=[(64, '64'), (96, '96'), (128, '128')], default=64, editable=False, verbose_name='Load indicator size')),
                ('animation_speed', models.CharField(choices=[('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1'), ('1.1', '1.1'), ('1.2', '1.2'), ('1.3', '1.3'), ('1.4', '1.4'), ('1.5', '1.5'), ('1.6', '1.6'), ('1.7', '1.7'), ('1.8', '1.8')], default='0.8', editable=False, max_length=255, verbose_name='Load indicator animation speed')),
                ('disable_indicator_animation', models.BooleanField(default=False, editable=False, help_text='It may be useful for the abbreviation or logo of the company, if it does not make sense to animate them.', verbose_name='Disable loading indicator animation')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('active', models.BooleanField(default=True, verbose_name='Active map ?')),
                ('zoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=3, verbose_name='Zoom')),
                ('latitude', models.CharField(default='0', help_text='Latitude center of the map.', max_length=255, validators=[djeym.utils.validate_coordinates], verbose_name='Latitude')),
                ('longitude', models.CharField(default='0', help_text='Longitude center of the map.', max_length=255, validators=[djeym.utils.validate_coordinates], verbose_name='Longitude')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('demo_categories', models.BooleanField(blank=True, default=True, editable=False, verbose_name='Add one-time categories')),
                ('icon_cluster', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ymap', to='djeym.ClusterIcon', verbose_name='Icon for cluster')),
                ('icon_collection', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ymap', to='djeym.IconCollection', verbose_name='Icon collection for markers')),
                ('load_indicator', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ymap', to='djeym.LoadIndicator', verbose_name='Load indicator')),
            ],
            options={
                'verbose_name': 'Map',
                'verbose_name_plural': 'Map',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='Statistics',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('obj_type', models.CharField(default='', max_length=255, verbose_name='Object type')),
                ('obj_id', models.PositiveIntegerField(default=0, verbose_name='Object ID')),
                ('ip', models.GenericIPAddressField(null=True, verbose_name='IP-address')),
                ('likes', models.BooleanField(default=False, verbose_name='Likes')),
                ('timestamp', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Date and Time')),
            ],
            options={
                'verbose_name': 'Record',
                'verbose_name_plural': 'Statistics',
            },
        ),
        migrations.CreateModel(
            name='TileSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(default='', max_length=255, unique=True, verbose_name='Title')),
                ('maxzoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=12, verbose_name='Maximum zoom')),
                ('minzoom', models.PositiveSmallIntegerField(choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23)], default=0, verbose_name='Minimum zoom')),
                ('source', models.TextField(default='', verbose_name='Source')),
                ('screenshot', models.ImageField(help_text='Recommended size - Width=360 x Height=180', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_image], verbose_name='Screenshot')),
                ('copyrights', models.TextField(default='', verbose_name='Copyrights')),
                ('site', models.URLField(blank=True, default='', verbose_name='Site')),
                ('apikey', models.CharField(blank=True, default='', help_text='API key or access_token', max_length=255, verbose_name='API Key')),
                ('note', models.TextField(blank=True, default='', verbose_name='Note')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'Tile Source',
                'verbose_name_plural': 'Tile Sources',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='SubCategoryPolyline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Subcategory - This is a characteristic feature that routes have.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#0091EA', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
                ('ymap', adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subcategories_polyline', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': '_Subcategory of route',
                'verbose_name_plural': '_Subcategory of routes',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='SubCategoryPolygon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Subcategory - This is a characteristic feature that the territories have.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#0091EA', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
                ('ymap', adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subcategories_polygon', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': '_Subcategory of territory',
                'verbose_name_plural': '_Subcategory of territories',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='SubCategoryPlacemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Subcategory - This is a characteristic feature that markers have. Examples: Parking or Bicycle Parking or ATM or Cafe or Wi-Fi or Playground, etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#0091EA', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
                ('ymap', adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subcategories_placemark', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': '_Subcategory of marker',
                'verbose_name_plural': '_Subcategory of markers',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Preset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveSmallIntegerField(default=0, verbose_name='Position')),
                ('title', models.CharField(default='', max_length=60, verbose_name='Title')),
                ('icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Icon')),
                ('html', models.TextField(default='<p style="color:#E91E63;">iPreset</p>', verbose_name='Text | Html')),
                ('js', models.TextField(blank=True, default='', help_text='JavaScript and jQuery', verbose_name='JS')),
                ('description', models.TextField(default='<div style="color:#3F51B5;">Описание</div>\n<div style="color:#E91E63;">Description</div>', help_text='Brief description of the preset.', verbose_name='Description')),
                ('autoheader', models.BooleanField(default=False, verbose_name='Automatically add to end of header')),
                ('autobody', models.BooleanField(default=False, verbose_name='Automatically add to end of description')),
                ('autofooter', models.BooleanField(default=False, verbose_name='Automatically add to end of footer')),
                ('placemark', models.BooleanField(default=True, verbose_name='Markers')),
                ('polyline', models.BooleanField(default=True, verbose_name='Routes')),
                ('polygon', models.BooleanField(default=True, verbose_name='Territorys')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True)),
                ('ymap', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='presets', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Preset',
                'verbose_name_plural': 'Presets',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Polyline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', ckeditor_uploader.fields.RichTextUploadingField(default='', verbose_name='Route name')),
                ('body', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Description of the geo object')),
                ('footer', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Footer')),
                ('stroke_width', models.PositiveIntegerField(default=5, verbose_name='Stroke width')),
                ('stroke_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#00C853', verbose_name='Line color')),
                ('stroke_style', models.CharField(choices=[('solid', 'Solid line'), ('dash', 'Dash'), ('dashdot', 'Long dash-short dash'), ('dot', 'Dots'), ('longdash', 'Long dashes'), ('longdashdot', 'Extra long dash-dot'), ('longdashdotdot', 'Long dash-dot-dot'), ('shortdash', 'Short dashes'), ('shortdashdot', 'Dash-dot'), ('shortdashdotdot', 'Dash-dot-dot'), ('shortdot', 'Dots with double spacing')], default='solid', max_length=255, verbose_name='Line style')),
                ('stroke_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Opacity line')),
                ('coordinates', models.TextField(default='', verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active route ?')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "LineString", "coordinates": []}, "properties": {"id": 0, "categoryID": 0, "subCategoryIDs": []}, "options": {"strokeWidth": 5, "strokeColor": "#00c853", "strokeStyle": "solid", "strokeOpacity": 0.9}}', editable=False, verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('is_created', models.BooleanField(default=False, editable=False, verbose_name='Is created ?')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polylines', to='djeym.CategoryPlacemark', verbose_name='Category')),
                ('subcategories', models.ManyToManyField(blank=True, related_name='polylines', to='djeym.SubCategoryPlacemark', verbose_name='Subcategories')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polylines', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Route',
                'verbose_name_plural': 'Routes',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Polygon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', ckeditor_uploader.fields.RichTextUploadingField(default='', verbose_name='Territory name')),
                ('body', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Description of the geo object')),
                ('footer', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Footer')),
                ('stroke_width', models.PositiveIntegerField(default=2, verbose_name='Stroke width')),
                ('stroke_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#4caf50', verbose_name='Line color')),
                ('stroke_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Opacity line')),
                ('fill_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#00C853', verbose_name='Fill color')),
                ('stroke_style', models.CharField(choices=[('solid', 'Solid line'), ('dash', 'Dash'), ('dashdot', 'Long dash-short dash'), ('dot', 'Dots'), ('longdash', 'Long dashes'), ('longdashdot', 'Extra long dash-dot'), ('longdashdotdot', 'Long dash-dot-dot'), ('shortdash', 'Short dashes'), ('shortdashdot', 'Dash-dot'), ('shortdashdotdot', 'Dash-dot-dot'), ('shortdot', 'Dots with double spacing')], default='solid', max_length=255, verbose_name='Line style')),
                ('fill_opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.9', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Fill opacity')),
                ('coordinates', models.TextField(default='', verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active territory ?')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Polygon", "coordinates": []}, "properties": {"id": 0, "categoryID": 0, "subCategoryIDs": []}, "options": {"strokeWidth": 2, "strokeColor": "#00c853", "strokeStyle": "solid", "strokeOpacity": 0.9, "fillColor": "#00E676", "fillOpacity": 0.9}}', editable=False, verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('is_created', models.BooleanField(default=False, editable=False, verbose_name='Is created ?')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polygons', to='djeym.CategoryPlacemark', verbose_name='Category')),
                ('subcategories', models.ManyToManyField(blank=True, related_name='polygons', to='djeym.SubCategoryPlacemark', verbose_name='Subcategories')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='polygons', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Territorys',
                'verbose_name_plural': 'Territorys',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='Placemark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('header', ckeditor_uploader.fields.RichTextUploadingField(default='', verbose_name='Place name')),
                ('body', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Description of the geo object')),
                ('user_image', models.ImageField(blank=True, editable=False, help_text='Image from the user to description the geo-object (width = 966px, quality = 40).', null=True, upload_to=djeym.utils.make_upload_path, verbose_name='Image from user')),
                ('footer', ckeditor_uploader.fields.RichTextUploadingField(blank=True, default='', verbose_name='Footer')),
                ('icon_slug', models.SlugField(max_length=255, null=True, verbose_name='Icon (slug)')),
                ('coordinates', models.CharField(default='[0,0]', max_length=255, verbose_name='Coordinates')),
                ('like', models.PositiveIntegerField(blank=True, default=0, verbose_name='Like')),
                ('dislike', models.PositiveIntegerField(blank=True, default=0, verbose_name='Dislike')),
                ('active', models.BooleanField(default=True, verbose_name='Active placemark ?')),
                ('user_email', models.EmailField(blank=True, help_text="To automatically send a one-time message if the user's marker has been moderated and activated.", max_length=254, null=True, verbose_name='User Email')),
                ('user_ip', models.GenericIPAddressField(blank=True, help_text='Ban user if vandalism is to be prevented.', null=True, verbose_name='User IP')),
                ('is_user_marker', models.BooleanField(default=False, verbose_name='Is user marker ?')),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Point", "coordinates": []}, "properties": {"id": 0, "categoryID": 0, "subCategoryIDs": [], "iconSlug": ""}, "options": {"iconLayout": "default#image", "iconImageHref": "", "iconImageSize": [], "iconImageOffset": []}}', editable=False, verbose_name='JSON')),
                ('created_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('is_created', models.BooleanField(default=False, editable=False, verbose_name='Is created ?')),
                ('is_sended_admin_email', models.BooleanField(default=False, editable=False, verbose_name='Is sent to admin by email ?')),
                ('is_sended_user_email', models.BooleanField(default=False, editable=False, verbose_name='Is sended user email ?')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='placemarks', to='djeym.CategoryPlacemark', verbose_name='Category')),
                ('subcategories', models.ManyToManyField(blank=True, related_name='placemarks', to='djeym.SubCategoryPlacemark', verbose_name='Subcategories')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='placemarks', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Marker',
                'verbose_name_plural': 'Markers',
                'ordering': ('-id',),
            },
        ),
        migrations.CreateModel(
            name='MarkerIcon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('svg', models.FileField(help_text='Only SVG files.', null=True, upload_to=djeym.utils.make_upload_path, validators=[djeym.utils.validate_svg], verbose_name='Icon')),
                ('title', models.CharField(default='', help_text='Example: Airport', max_length=60, verbose_name='Icon name')),
                ('size_width', models.PositiveSmallIntegerField(default=0, verbose_name='Icon width')),
                ('size_height', models.PositiveSmallIntegerField(default=0, verbose_name='Icon height')),
                ('offset_x', models.DecimalField(decimal_places=1, default=Decimal('0.0'), help_text='Left, right - First time is automatically calculated.', max_digits=3, verbose_name='Offset by axis - X')),
                ('offset_y', models.DecimalField(decimal_places=1, default=Decimal('0.0'), help_text='Up, down - First time is automatically calculated.', max_digits=3, verbose_name='Offset by axis - Y')),
                ('active', models.BooleanField(default=True, help_text='If the project uses 2-3 icons, it makes sense to disable the rest to optimize the download.', verbose_name='Active icon ?')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True)),
                ('icon_collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='icons', to='djeym.IconCollection', verbose_name='Icon Collection')),
            ],
            options={
                'verbose_name': 'Icons for markers',
                'verbose_name_plural': 'Icons for markers',
                'ordering': ('title', 'id'),
            },
        ),
        migrations.CreateModel(
            name='MapControls',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('geolocation', models.BooleanField(default=True, verbose_name='Geolocation')),
                ('search', models.BooleanField(default=True, verbose_name='Search by map')),
                ('provider', models.BooleanField(default=True, verbose_name='Search by organization name')),
                ('route', models.BooleanField(default=True, verbose_name='Routing panel')),
                ('traffic', models.BooleanField(default=True, verbose_name='Traffic jams')),
                ('typeselector', models.BooleanField(default=True, verbose_name='Map Layer Switch')),
                ('fullscreen', models.BooleanField(default=True, verbose_name='Full screen mode')),
                ('zoom', models.BooleanField(default=True, verbose_name='Zoom')),
                ('ruler', models.BooleanField(default=True, verbose_name='Ruler')),
                ('ymap', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='map_controls', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name_plural': 'Map Controls',
            },
        ),
        migrations.AddField(
            model_name='map',
            name='tile',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='ymap', to='djeym.TileSource', verbose_name='Tile Source'),
        ),
        migrations.CreateModel(
            name='JsonSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('editor', models.TextField(default='{}', verbose_name='All settings for editor page')),
                ('front', models.TextField(default='{}', verbose_name='All settings for front page')),
                ('ymap', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='json_settings', to='djeym.Map', verbose_name='Map')),
            ],
        ),
        migrations.CreateModel(
            name='HeatPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, default='', max_length=60, verbose_name='Place name')),
                ('weight', models.PositiveIntegerField(blank=True, default=0, help_text='Examples: Average property value on a district site or Number of cameras installed on a building, etc.', verbose_name='Weight')),
                ('coordinates', models.CharField(default='[0,0]', max_length=255, verbose_name='Coordinates')),
                ('active', models.BooleanField(default=True, verbose_name='Active heat point ?')),
                ('slug', models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                ('json_code', models.TextField(blank=True, default='{"type": "Feature", "id": 0, "geometry": {"type": "Point", "coordinates": []}, "properties": {"weight": 0}}', editable=False, verbose_name='JSON')),
                ('is_created', models.BooleanField(default=False, editable=False, verbose_name='Is created ?')),
                ('ymap', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='heat_points', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Heat points',
                'verbose_name_plural': 'Heat points',
            },
        ),
        migrations.CreateModel(
            name='HeatmapSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('radius', models.PositiveIntegerField(default=10, verbose_name='Point radius of influence (px)')),
                ('dissipating', models.BooleanField(default=False, help_text="Enable - Disperse points on higher zoom levels according to radius. Disable - Don't disperse.", verbose_name='Disperse points')),
                ('opacity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.8', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Transparency of heat layer')),
                ('intensity', models.CharField(choices=[('0', '0'), ('0.1', '0.1'), ('0.2', '0.2'), ('0.3', '0.3'), ('0.4', '0.4'), ('0.5', '0.5'), ('0.6', '0.6'), ('0.7', '0.7'), ('0.8', '0.8'), ('0.9', '0.9'), ('1', '1')], default='0.2', max_length=255, validators=[djeym.utils.validate_transparency], verbose_name='Intensity of median point')),
                ('gradient_color1', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#66BB6A', verbose_name='gradient color 1')),
                ('gradient_color2', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#FDD835', verbose_name='gradient color 2')),
                ('gradient_color3', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#EF5350', verbose_name='gradient color 3')),
                ('gradient_color4', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#B71C1C', verbose_name='gradient color 4')),
                ('active', models.BooleanField(default=False, verbose_name='Active Heatmap ?')),
                ('ymap', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='heatmap_settings', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'Heatmap',
                'verbose_name_plural': 'Heatmap',
            },
        ),
        migrations.CreateModel(
            name='GeneralSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('clustering_edit', models.BooleanField(default=True, verbose_name='Сlustering in editor')),
                ('clustering_site', models.BooleanField(default=True, verbose_name='Сlustering on site')),
                ('cluster_layout', models.CharField(choices=[('cluster#balloonTwoColumns', 'Two Columns'), ('cluster#balloonCarousel', 'Carousel')], default='cluster#balloonTwoColumns', max_length=255, verbose_name='Layout for the cluster information window')),
                ('cluster_icon_content', models.BooleanField(default=True, verbose_name='Display the number of objects in the cluster icon')),
                ('cluster_icon_content_bg_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#F5F5F5', verbose_name='Background color')),
                ('cluster_icon_content_txt_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#212121', verbose_name='Text color')),
                ('controls_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#FFA000', verbose_name='Color of controls')),
                ('buttons_text_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#FAFAFA', verbose_name='Text color on buttons')),
                ('theme_type', models.CharField(choices=[('light', 'Light'), ('dark', 'Dark')], default='light', max_length=255, verbose_name='Theme type - light | dark')),
                ('roundtheme', models.BooleanField(default=False, verbose_name='Round theme of controls')),
                ('panorama', models.BooleanField(default=True, verbose_name='Panorama - on|off')),
                ('width_panel_editor', models.PositiveSmallIntegerField(default=380, verbose_name='Width for panel of editor')),
                ('width_panel_front', models.PositiveSmallIntegerField(default=380, verbose_name='Width for panel of front')),
                ('open_panel_front', models.BooleanField(default=False, verbose_name='Open panel automatically')),
                ('img_bg_panel_front', models.ImageField(blank=True, null=True, upload_to=djeym.utils.make_upload_path, verbose_name='Background image for the site panel')),
                ('tinting_panel_front', models.CharField(default='#00000000', max_length=9, verbose_name='Background under controls of panel')),
                ('hide_group_name_panel_front', models.BooleanField(default=False, verbose_name='Hide group names (Categories, Subcategories)')),
                ('width_map_front', models.CharField(default='100%', max_length=255, verbose_name='Width of Map for Front page')),
                ('height_map_front', models.CharField(default='600px', max_length=255, verbose_name='Height of Map for Front page')),
                ('ymap', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='general_settings', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': 'General settings',
                'verbose_name_plural': 'General settings',
            },
        ),
        migrations.CreateModel(
            name='CategoryPolyline',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Examples: Tourist routes or Marathon routes etc.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#00C853', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
                ('ymap', adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='categories_polyline', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': '-Category of route',
                'verbose_name_plural': '-Category of routes',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='CategoryPolygon',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='The name of the aggregate of any geographic area. Examples: Honduran cities or Hawaiian beaches or Residential complexes in Antarctica.', max_length=60, verbose_name='Title')),
                ('category_icon', models.CharField(default='', help_text='http://materialdesignicons.com/ - Example: help OR mdi-help', max_length=255, verbose_name='Category Icon')),
                ('category_color', colorful.fields.RGBColorField(colors=('#F44336', '#C62828', '#E91E63', '#AD1457', '#9C27B0', '#6A1B9A', '#673AB7', '#4527A0', '#3F51B5', '#283593', '#2196F3', '#1565C0', '#0091EA', '#03A9F4', '#0277BD', '#00BCD4', '#00838F', '#009688', '#00695C', '#4CAF50', '#2E7D32', '#00C853', '#8BC34A', '#558B2F', '#CDDC39', '#9E9D24', '#FFEB3B', '#F9A825', '#FFC107', '#FF8F00', '#FF9800', '#EF6C00', '#FF5722', '#D84315', '#795548', '#4E342E', '#607D8B', '#37474F', '#FAFAFA', '#F5F5F5', '#EEEEEE', '#E0E0E0', '#BDBDBD', '#9E9E9E', '#757575', '#616161', '#424242', '#212121', '#000000', '#FFFFFF'), default='#00C853', verbose_name='Category color')),
                ('position', models.PositiveIntegerField(db_index=True, default=0, editable=False)),
                ('active', models.BooleanField(default=True, verbose_name='Active category ?')),
                ('ymap', adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='categories_polygon', to='djeym.Map', verbose_name='Map')),
            ],
            options={
                'verbose_name': '-Category of territory',
                'verbose_name_plural': '-Category of territories',
                'ordering': ('position',),
            },
        ),
        migrations.AddField(
            model_name='categoryplacemark',
            name='ymap',
            field=adminsortable.fields.SortableForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='categories_placemark', to='djeym.Map', verbose_name='Map'),
        ),
    ]
