

# PyCommandsTool  2.0.X
PyCommandsTool, through the magic of [Decorators](https://peps.python.org/pep-0318/), allows you to easily bind commands to tokens that can be input in the console and executed seamlessly! Read below for more info!  

For around two years, PyCommandsTool was deprecated. However, I have returned to development on it for a project that uses this tool. I have updated it immensely and hope it can be of as much use to you all as it has been to me.

[Need the documentation?](https://github.com/HavenSelph/PyCommands/blob/master/DOCS.md)

> *Copyright Haven Selph 2022, MIT License, see [LICENSE.md](https://github.com/HavenSelph/PyCommands/blob/master/LICENSE.md) file for more info.*
### Key Features  
- Allows any function to be linked to a custom name and aliases.   
- Parses user input and allows the passing of function arguments ex:
	- `<command> arg1 arg2 "arg 3"`  
	- `<command> arg1=str arg2=#int`
	- `<command> arg1=[this, is, a, list] arg2=str`
	- Parser also has specific errors, and you can handle them as you wish! For instance, if a command is not 	   found, execute will return with a `NoSuchCommand` error.  Or, if no input is passed, it will return `NoValidInput`. There are a couple more instances, check below for more info on specific parts!
- Auto generated help command to list all of your commands and their uses. (Requires you to set them explicitly.)
- Very customizable settings so you can use this tool how you want to!
  
### Installing The Tool

```
Linux/Windows:  
pip install PyCommandsTool  
```
  
### Using The Tool

```python  
from src.PyCommandsTool import Commands

COMMANDMODULE = Commands()


# This is a decorator, it passes the below function as the first argument!
@COMMANDMODULE.add_command("hi", does="prints hello world")
def hi():
	print("Hello world!")


# You can pass an infinite number of names for the command to be known as
# then at the end, you can pass "does" so you can have a description for it!
@COMMANDMODULE.add_command("echo", "repeat", "print", does="prints any passed arguments")
def echo(*args):
	for x in args:
		print(str(x))


@COMMANDMODULE.add_command("echotwice", "repeattwice", "printtwice", does="prints any passed arguments; but twice")
def echotwice(*args):
	print(args)
	for x in args:
		print(str(x), str(x), sep="\n")


# Decorators are just a pretty way of doing the below:
def add(a: int, b: int, *args: int, print_it: bool = True) -> int:
	x = sum((a, b, *args))
	if print_it:
		print(x)
	return x


# Notice how in this, I pass the function as an argument. Functionally, this works EXACTLY the same as the above "decorators"
add = COMMANDMODULE.add_command("add", does="returns the sum of all passed arguments (integers required)")(add)

# Now that you've made and registered all your commands, you can create an input loop:
try:
	while True:
		try:
			last = COMMANDMODULE.execute(input(">>> "))
			if last[0] == 0:
				# Code did not encounter an error!
				pass
		except COMMANDMODULE.NoValidInput as e:
			# This is actually a ParseError which can be caught as shown below this except statement!
			print(e)

		except COMMANDMODULE.ParseError as e:
			# Code here runs when any parse error is thrown!
			print(e)
		except COMMANDMODULE.NoSuchCommand as e:
			# Code here runs if the command passed doesn't exist!
			print(e)
		except TypeError as e:
			# This is the except statement you need to add.
			print(e)

except KeyboardInterrupt:
	# Code here runs when CTRL+C is pressed, or when KeyboardInterrupt
	# is thrown as an error.
	pass
``` 
The above code will wait for input. Here's what it would output if you were to input "invalidcommand": 

![inavalid command output](https://cdn.discordapp.com/attachments/572921877668823041/1055632407899938927/image.png)

Here's what it would output if you input the add command, but didn't pass integers to it:

![error output](https://cdn.discordapp.com/attachments/572921877668823041/1055632763480449044/image.png)

Since this tool doesn't actually catch errors, you are going to have to do this yourself. To stop this from happening, you could add an except to your input loop:

```python
try:
	...
except ... as e:
	...
except TypeError as e:
	# This is the except statement you need to add.
	print(e)
```
Now, the output after this change would be:

![better error output](https://cdn.discordapp.com/attachments/572921877668823041/1055637779998064760/image.png)

Make sure to read the DOCs for more info. Thanks for using PyCommandsTool!

### Issues?
If you believe you have found a REAL issue with my tool, open a [GitHub Issue](https://github.com/HavenSelph/PyCommands/issues/new/choose) and describe it thoroughly. Please include your code (or something alike that reproduces it) and ANY changes to mine. If you know of a fix, you could also describe that to help me get it fixed quicker!