# 天干地支干支

## 天干

天干（celestial stem）是中国古代的一种文字计序符号，共10个字:甲、乙、丙、丁、戊、己、庚、辛、壬、癸，循环使用。

## 地支

地支（terrestrial branch）是中国古代的一种文字计序符号，共12个字∶子、丑、寅、卯、辰、巳、午、未、申、酉、戌、亥，循环使用。

## 干支

六十干支周（sexagesimal cycle）是中国古代把天干和地支各循序取一字相配成一对干支，形成一种新的较长的计序符号系统，如:甲子、乙丑、丙寅……等，共可配成60对干支，然后周而复始，故称六十干支周。

## 十天干十二地支六十干支

| 天干  | 地支  | 索引  | 干支  |  阳历  |
|:---:|:---:|:---:|:---:|:----:|
|  甲  |  子  |  1  | 甲子  | 1984 |
|  乙  |  丑  |  2  | 乙丑  | 1985 |
|  丙  |  寅  |  3  | 丙寅  | 1986 |
|  丁  |  卯  |  4  | 丁卯  | 1987 |
|  戊  |  辰  |  5  | 戊辰  | 1988 |
|  己  |  巳  |  6  | 己巳  | 1989 |
|  庚  |  午  |  7  | 庚午  | 1990 |
|  辛  |  未  |  8  | 辛未  | 1991 |
|  壬  |  申  |  9  | 壬申  | 1992 |
|  癸  |  酉  | 10  | 癸酉  | 1993 |
|  甲  |  戌  | 11  | 甲戌  | 1994 |
|  乙  |  亥  | 12  | 乙亥  | 1995 |
|  丙  |  子  | 13  | 丙子  | 1996 |
|  丁  |  丑  | 14  | 丁丑  | 1997 |
|  戊  |  寅  | 15  | 戊寅  | 1998 |
|  己  |  卯  | 16  | 己卯  | 1999 |
|  庚  |  辰  | 17  | 庚辰  | 2000 |
|  辛  |  巳  | 18  | 辛巳  | 2001 |
|  壬  |  午  | 19  | 壬午  | 2002 |
|  癸  |  未  | 20  | 癸未  | 2003 |
|  甲  |  申  | 21  | 甲申  | 2004 |
|  乙  |  酉  | 22  | 乙酉  | 2005 |
|  丙  |  戌  | 23  | 丙戌  | 2006 |
|  丁  |  亥  | 24  | 丁亥  | 2007 |
|  戊  |  子  | 25  | 戊子  | 2008 |
|  己  |  丑  | 26  | 己丑  | 2009 |
|  庚  |  寅  | 27  | 庚寅  | 2010 |
|  辛  |  卯  | 28  | 辛卯  | 2011 |
|  壬  |  辰  | 29  | 壬辰  | 2012 |
|  癸  |  巳  | 30  | 癸巳  | 2013 |
|  甲  |  午  | 31  | 甲午  | 2014 |
|  乙  |  未  | 32  | 乙未  | 2015 |
|  丙  |  申  | 33  | 丙申  | 2016 |
|  丁  |  酉  | 34  | 丁酉  | 2017 |
|  戊  |  戌  | 35  | 戊戌  | 2018 |
|  己  |  亥  | 36  | 己亥  | 2019 |
|  庚  |  子  | 37  | 庚子  | 2020 |
|  辛  |  丑  | 38  | 辛丑  | 2021 |
|  壬  |  寅  | 39  | 壬寅  | 2022 |
|  癸  |  卯  | 40  | 癸卯  | 2023 |
|  甲  |  辰  | 41  | 甲辰  | 2024 |
|  乙  |  巳  | 42  | 乙巳  | 2025 |
|  丙  |  午  | 43  | 丙午  | 2026 |
|  丁  |  未  | 44  | 丁未  | 2027 |
|  戊  |  申  | 45  | 戊申  | 2028 |
|  己  |  酉  | 46  | 己酉  | 2029 |
|  庚  |  戌  | 47  | 庚戌  | 2030 |
|  辛  |  亥  | 48  | 辛亥  | 2031 |
|  壬  |  子  | 49  | 壬子  | 2032 |
|  癸  |  丑  | 50  | 癸丑  | 2033 |
|  甲  |  寅  | 51  | 甲寅  | 2034 |
|  乙  |  卯  | 52  | 乙卯  | 2035 |
|  丙  |  辰  | 53  | 丙辰  | 2036 |
|  丁  |  巳  | 54  | 丁巳  | 2037 |
|  戊  |  午  | 55  | 戊午  | 2038 |
|  己  |  未  | 56  | 己未  | 2039 |
|  庚  |  申  | 57  | 庚申  | 2040 |
|  辛  |  酉  | 58  | 辛酉  | 2041 |
|  壬  |  戌  | 59  | 壬戌  | 2042 |
|  癸  |  亥  | 60  | 癸亥  | 2043 |

## 常量

```python
# for loop
from stembranch import stem, branch

for i, j in zip(stem * 6, branch * 5):
    print(i + j)

```

```python
from stembranch import stem, branch

print(list(i + j for i, j in zip(stem * 6, branch * 5)))
print(tuple(i + j for i, j in zip(stem * 6, branch * 5)))
print([i + j for i, j in zip(stem * 6, branch * 5)])
print(*(i + j for i, j in zip(stem * 6, branch * 5)))

```

```python
from stembranch import stem, branch

print(tuple(map(lambda i, j: i + j, stem * 6, branch * 5)))
print(list(map(lambda i, j: i + j, stem * 6, branch * 5)))
print(*map(lambda i, j: i + j, stem * 6, branch * 5))
print([*map(lambda i, j: i + j, stem * 6, branch * 5)])

```

```python
from stembranch import stem, branch

for i in range(60):
    print(stem[i % 10] + branch[i % 12])

```

```python
from stembranch import stem, branch

print(*(stem[i % 10] + branch[i % 12] for i in range(60)))
print([stem[i % 10] + branch[i % 12] for i in range(60)])
print(list(stem[i % 10] + branch[i % 12] for i in range(60)))
print(tuple(stem[i % 10] + branch[i % 12] for i in range(60)))

```

## 函数

```python
from stembranch import stembranch

print(stembranch(2022))

```

## 类

```python
from stembranch import StemBranch

stembranch = StemBranch()
print(stembranch.stem)
print(stembranch.branch)
print(stembranch.stembranch(2022))

```