class Error:

    def __str__(self):
        if self.err_info not in self.errors:
            return "%s : An unknown error has occurred" % (self.err_info,)

        return "%s : %s" % (self.err_info, self.errors[self.err_info])

    def __repr__(self):
        return self.__str__()

    def __init__(self, err_info_code):
        self.err_info = str(err_info_code)
        self._set_errors()

    def to_dict(self):
        if self.err_info not in self.errors:
            return {self.err_info: 'An unknown error has occurred'}

        return {self.err_info: self.errors[self.err_info]}

    def _set_errors(self):
        self.errors = {
            'E00000000': 'Nothing special',
            'E01010001': 'Shop ID is not specified',
            'E01020001': 'Shop password is not specified',
            'E01030002': 'The shop with the specified ID and password does not exist.',
            'E01040001': 'Order ID not specified',
            'E01040003': 'The order ID exceeds the maximum number of characters',
            'E01040010': 'Order ID already exists',
            'E01040013': 'There are invalid characters in the order ID',
            'E01050001': 'Processing class is not specified',
            'E01050002': 'The specified processing category is not defined',
            'E01050004': 'The process of the specified process category cannot be executed',
            'E01060001': 'No amount specified',
            'E01060005': 'The amount used exceeds the maximum number of digits',
            'E01060006': 'The usage amount contains characters other than numbers',
            'E01070005': 'Tax shipping exceeds the maximum number of digits',
            'E01070006': 'The tax postage contains non-numeric characters',
            'E01080007': 'A value other than 0 or 1 is specified for the 3D Secure use flag',
            'E01090001': 'Transaction ID not specified',
            'E01100001': 'You have not specified a transaction password',
            'E01110002': 'The transaction with the specified ID and password does not exist',
            'E01120008': 'The card type format is incorrect',
            'E01130002': 'The specified card abbreviation does not exist',
            'E01140007': 'A value other than 0,1 is specified for the supported payment method',
            'E01140003': 'The supported payment method exceeds the maximum number of characters',
            'E01150007': 'A value other than 0 or 1 is specified for the number of corresponding divisions',
            'E01160007': 'A value other than 0 or 1 is specified for the number of corresponding bonus divisions',
            'E01170001': 'No card number specified',
            'E01170003': 'The card number exceeds the maximum number of characters',
            'E01170006': 'The card number contains non-numeric characters',
            'E01170011': 'The card number is not within the range of 10 to 16 digits',
            'E01180001': 'No expiration date specified',
            'E01180003': 'Expiration date is not 4 digits',
            'E01180006': 'The expiration date contains non-numeric characters',
            'E01190001': 'Site ID not specified',
            'E01200001': 'No site password specified',
            'E01210002': 'The site with the specified ID and password does not exist',
            'E01220001': 'Member ID is not specified',
            'E01230001': 'Card registration serial number is not specified',
            'E01230006': 'The card registration serial number contains characters other than numbers',
            'E01230009': 'The card registration serial number has exceeded the maximum number that can be registered',
            'E01240002': 'The specified site ID, member ID, and card serial number do not exist',
            'E01250010': 'Card password does not match',
            'E01260001': 'No payment method specified',
            'E01250002': 'The specified payment method does not exist',
            'E01260010': 'The specified payment method cannot be used',
            'E01270001': 'No number of payments specified',
            'E01270005': 'The number of payments is not 1 or 2 digits',
            'E01270006': 'It contains characters other than numbers in the number of payments',
            'E01270010': 'The specified number of payments cannot be used',
            'E01280012': 'Merchant URL value exceeds maximum number of bytes',
            'E01290001': 'HTTP_ACCEPT was not specified',
            'E01300001': 'HTTP_USER_AGENT not specified',
            'E01310001': 'No terminal is specified',
            'E01310007': 'A value other than 0 or 1 is specified for the terminal used',
            'E01320012': 'The value of Merchant Free Item 1 exceeds the maximum number of bytes',
            'E01330012': 'The value of Merchant Free Item 2 exceeds the maximum number of bytes',
            'E01340012': 'The value of Merchant Free Item 3 exceeds the maximum number of bytes',
            'E01350001': 'No MD specified',
            'E01360001': 'No PaREs specified',
            'E01370012': 'The 3D Secure display store name value exceeds the maximum number of bytes',
            'E01380007': 'A value other than 0 or 1 is specified for the payment method flag',
            'E01390002': 'The specified combination of site ID and member ID does not exist',
            'E01390010': 'The specified site ID and member ID combination already exists',
            'E11010001': 'This transaction has already been settled',
            'E11010002': 'This transaction has not been settled, so it cannot be changed',
            'E11010003': 'This transaction cannot be processed with the specified processing classification',
            'E21010001': '3D secure authentication failed. Please try again from the purchase screen',
            'E21020001': '3D secure authentication failed. Please try again from the purchase screen',
            'E21020002': '3D secure authentication canceled. Please try again from the purchase screen',
            'E41170002': 'The card company entered is not supported. Please enter another card number',
            'E41170099': 'There is an error in the card number. Please check and enter again',
            'E61010001': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            'E61010002': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            'E61010003': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            'E90010001': 'We are currently processing it, so please wait for a while',
            'E91019999': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            'E91029999': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            'E91099999': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C010000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C030000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C120000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C130000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C140000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C150000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C500000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C510000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C530000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C540000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C550000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C560000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C570000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C580000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C600000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C700000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C710000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C720000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C730000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C740000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C750000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C760000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C770000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42C780000': 'Payment processing failed. We apologize for the inconvenience, but please try again from the purchase screen after a while',
            '42G020000': 'The payment could not be completed due to insufficient card balance',
            '42G030000': 'The payment could not be completed because the card limit has been exceeded',
            '42G040000': 'The payment could not be completed due to insufficient card balance',
            '42G050000': 'The payment could not be completed because the card limit has been exceeded',
            '42G120000': 'This card cannot be used for transactions',
            '42G220000': 'This card cannot be used for transactions',
            '42G300000': '',
            '42G420000': 'The payment could not be completed because the PIN was incorrect',
            '42G540000': 'This card cannot be used for transactions',
            '42G550000': 'The payment could not be completed because the card limit has been exceeded',
            '42G560000': '',
            '42G600000': 'This card cannot be used for transactions',
            '42G610000': 'This card cannot be used for transactions',
            '42G650000': 'The payment could not be completed due to an error in the card number',
            '42G670000': 'The payment could not be completed due to an error in the product code',
            '42G680000': 'The payment could not be completed because the amount was incorrect',
            '42G690000': 'The payment could not be completed due to an error in the tax and shipping charges',
            '42G700000': 'The payment could not be completed due to an error in the number of bonuses',
            '42G710000': 'The payment could not be completed due to an error in the bonus month',
            '42G720000': 'The payment could not be completed due to an error in the bonus amount',
            '42G730000': 'The payment could not be completed due to an error in the payment start month',
            '42G740000': 'The payment could not be completed due to an error in the number of divisions',
            '42G750000': 'The payment could not be completed due to an error in the split amount',
            '42G760000': 'The payment could not be completed because the initial amount was incorrect',
            '42G770000': 'The payment could not be completed due to an error in the business classification.',
            '42G780000': 'The payment could not be completed due to an error in the payment class',
            '42G790000': 'The payment could not be completed due to an error in the inquiry indicator',
            '42G800000': 'The payment could not be completed due to an error in the cancellation indicator',
            '42G810000': 'The payment could not be completed due to an error in the cancellation handling category',
            '42G830000': 'The payment could not be completed due to an incorrect expiration date',
            '42G950000': '',
            '42G960000': 'This card cannot be used for transactions.',
            '42G970000': 'This card cannot be used for transactions.',
            '42G980000': 'This card cannot be used for transactions.',
            '42G990000': 'This card cannot be used for transactions'
        }
