"""
This type stub file was generated by pyright.
"""

from pydantic import BaseModel
from typing import Any, Dict, List, Optional

class Model(BaseModel):
    class Config:
        extra: str

class ServiceInfo(Model):
    name: str
    options: Optional[Dict[str, Any]]

class ListServicesResponse(Model):
    services: List[ServiceInfo]

class TransformDocumentResponse(Model):
    document: str
    output: Optional[List[str]]
    error: Optional[List[str]]

class TransformDocumentRequest(Model):
    document: str
    service_name: str
    file_name: Optional[str] = None
    options: Optional[Dict[str, Any]] = None

class PipeService(Model):
    name: str
    options: Optional[Dict[str, Any]]

class TransformDocumentPipeRequest(Model):
    document: str
    services: List[PipeService]
    file_name: Optional[str] = None

class TransformDocumentPipeResponse(Model):
    document: str
    output: Optional[List[str]] = None
    error: Optional[List[str]] = None
    last_transformer: str

class OptionsPropertyError(Model):
    name: str
    message: str

class OptionsErrorResponse(Model):
    code: int
    properties: List[OptionsPropertyError]

class ErrorResponse(Model):
    code: int
    message: str

if __name__ == "__main__":
    class A(Model):
        a: str
        ...
    a = ErrorResponse()
