"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rule = exports.RuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pvtz_generated_1 = require("./pvtz.generated");
Object.defineProperty(exports, "RuleProperty", { enumerable: true, get: function () { return pvtz_generated_1.RosRule; } });
/**
 * A ROS resource type:  `ALIYUN::PVTZ::Rule`
 */
class Rule extends ros.Resource {
    /**
     * Create a new `ALIYUN::PVTZ::Rule`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRule = new pvtz_generated_1.RosRule(this, id, {
            forwardIp: props.forwardIp,
            zoneName: props.zoneName,
            type: props.type,
            endpointId: props.endpointId,
            ruleName: props.ruleName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRule;
        this.attrCreateTime = rosRule.attrCreateTime;
        this.attrEndpointId = rosRule.attrEndpointId;
        this.attrEndpointName = rosRule.attrEndpointName;
        this.attrForwardIp = rosRule.attrForwardIp;
        this.attrRuleName = rosRule.attrRuleName;
        this.attrType = rosRule.attrType;
        this.attrVpcs = rosRule.attrVpcs;
        this.attrZoneName = rosRule.attrZoneName;
    }
}
exports.Rule = Rule;
//# sourceMappingURL=data:application/json;base64,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