"""
    NLP Sandbox Data Node API

    # Overview  The NLP Sandbox Data Node is a repository of data used to benchmark NLP Tools like the NLP Sandbox Date Annotator and Person Name Annotator.  The resources that can be stored in this Data Node and the operations supported are listed below:  - Create and manage datasets - Create and manage FHIR stores   - Store and retrieve FHIR patient profiles   - Store and retrieve clinical   notes - Create and manage annotation stores   - Store and retrieve text annotations   # noqa: E501

    The version of the OpenAPI document: 1.0.2
    Contact: thomas.schaffter@sagebionetworks.org
    Generated by: https://openapi-generator.tech
"""


import unittest
from unittest.mock import patch

import nlpsandboxsdk
from nlpsandboxsdk.api.patient_api import PatientApi  # noqa: E501


class TestPatientApi(unittest.TestCase):
    """PatientApi unit test stubs"""

    def setUp(self):
        self.api = PatientApi()  # noqa: E501
        self.patcher = patch('nlpsandboxsdk.api_client.ApiClient.call_api')
        self.mock_foo = self.patcher.start()

    def tearDown(self):
        self.patcher.stop()

    def test_create_patient(self):
        """Test case for create_patient

        Create a FHIR patient  # noqa: E501
        """
        self.api.create_patient(
            dataset_id="awesome-dataset-id",
            fhir_store_id="awesome-fhir-store",
            patient_id="awesome-patient",
            patient_create_request={"gender": "female"}
        )

    def test_delete_patient(self):
        """Test case for delete_patient

        Delete a FHIR patient  # noqa: E501
        """
        self.api.delete_patient(
            dataset_id="awesome-dataset-id",
            fhir_store_id="awesome-fhir-store",
            patient_id="awesome-patient"
        )

    def test_get_patient(self):
        """Test case for get_patient

        Get a FHIR patient  # noqa: E501
        """
        self.api.get_patient(
            dataset_id="awesome-dataset-id",
            fhir_store_id="awesome-fhir-store",
            patient_id="awesome-patient"
        )

    def test_list_patients(self):
        """Test case for list_patients

        List the Patients in a FHIR store  # noqa: E501
        """
        self.api.list_patients(
            dataset_id="awesome-dataset-id",
            fhir_store_id="awesome-fhir-store"
        )


if __name__ == '__main__':
    unittest.main()
