"""
    NLP Sandbox API

    NLP Sandbox REST API  # noqa: E501

    The version of the OpenAPI document: 1.1.2
    Contact: team@nlpsandbox.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from nlpsandboxsdk.api_client import ApiClient, Endpoint as _Endpoint
from nlpsandboxsdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from nlpsandboxsdk.model.error import Error
from nlpsandboxsdk.model.text_person_name_annotation_request import TextPersonNameAnnotationRequest
from nlpsandboxsdk.model.text_person_name_annotation_response import TextPersonNameAnnotationResponse


class TextPersonNameAnnotationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_text_person_name_annotations(
            self,
            **kwargs
        ):
            """Annotate person names in a clinical note  # noqa: E501

            Return the person name annotations found in a clinical note  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_text_person_name_annotations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                text_person_name_annotation_request (TextPersonNameAnnotationRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TextPersonNameAnnotationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_text_person_name_annotations = _Endpoint(
            settings={
                'response_type': (TextPersonNameAnnotationResponse,),
                'auth': [],
                'endpoint_path': '/textPersonNameAnnotations',
                'operation_id': 'create_text_person_name_annotations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'text_person_name_annotation_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'text_person_name_annotation_request':
                        (TextPersonNameAnnotationRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'text_person_name_annotation_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_text_person_name_annotations
        )
