"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = exports.ProjectPushRulesOutputReference = exports.projectPushRulesToTerraform = exports.ProjectContainerExpirationPolicyOutputReference = exports.projectContainerExpirationPolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectContainerExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        cadence: cdktf.stringToTerraform(struct.cadence),
        enabled: cdktf.booleanToTerraform(struct.enabled),
        keep_n: cdktf.numberToTerraform(struct.keepN),
        name_regex_delete: cdktf.stringToTerraform(struct.nameRegexDelete),
        name_regex_keep: cdktf.stringToTerraform(struct.nameRegexKeep),
        older_than: cdktf.stringToTerraform(struct.olderThan),
    };
}
exports.projectContainerExpirationPolicyToTerraform = projectContainerExpirationPolicyToTerraform;
class ProjectContainerExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._cadence !== undefined) {
            hasAnyValues = true;
            internalValueResult.cadence = this._cadence;
        }
        if (this._enabled !== undefined) {
            hasAnyValues = true;
            internalValueResult.enabled = this._enabled;
        }
        if (this._keepN !== undefined) {
            hasAnyValues = true;
            internalValueResult.keepN = this._keepN;
        }
        if (this._nameRegexDelete !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexDelete = this._nameRegexDelete;
        }
        if (this._nameRegexKeep !== undefined) {
            hasAnyValues = true;
            internalValueResult.nameRegexKeep = this._nameRegexKeep;
        }
        if (this._olderThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.olderThan = this._olderThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._cadence = undefined;
            this._enabled = undefined;
            this._keepN = undefined;
            this._nameRegexDelete = undefined;
            this._nameRegexKeep = undefined;
            this._olderThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._cadence = value.cadence;
            this._enabled = value.enabled;
            this._keepN = value.keepN;
            this._nameRegexDelete = value.nameRegexDelete;
            this._nameRegexKeep = value.nameRegexKeep;
            this._olderThan = value.olderThan;
        }
    }
    get cadence() {
        return this.getStringAttribute('cadence');
    }
    set cadence(value) {
        this._cadence = value;
    }
    resetCadence() {
        this._cadence = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cadenceInput() {
        return this._cadence;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get keepN() {
        return this.getNumberAttribute('keep_n');
    }
    set keepN(value) {
        this._keepN = value;
    }
    resetKeepN() {
        this._keepN = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepNInput() {
        return this._keepN;
    }
    get nameRegexDelete() {
        return this.getStringAttribute('name_regex_delete');
    }
    set nameRegexDelete(value) {
        this._nameRegexDelete = value;
    }
    resetNameRegexDelete() {
        this._nameRegexDelete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexDeleteInput() {
        return this._nameRegexDelete;
    }
    get nameRegexKeep() {
        return this.getStringAttribute('name_regex_keep');
    }
    set nameRegexKeep(value) {
        this._nameRegexKeep = value;
    }
    resetNameRegexKeep() {
        this._nameRegexKeep = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nameRegexKeepInput() {
        return this._nameRegexKeep;
    }
    // next_run_at - computed: true, optional: false, required: false
    get nextRunAt() {
        return this.getStringAttribute('next_run_at');
    }
    get olderThan() {
        return this.getStringAttribute('older_than');
    }
    set olderThan(value) {
        this._olderThan = value;
    }
    resetOlderThan() {
        this._olderThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get olderThanInput() {
        return this._olderThan;
    }
}
exports.ProjectContainerExpirationPolicyOutputReference = ProjectContainerExpirationPolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectContainerExpirationPolicyOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.project.ProjectContainerExpirationPolicyOutputReference", version: "4.0.0" };
function projectPushRulesToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        author_email_regex: cdktf.stringToTerraform(struct.authorEmailRegex),
        branch_name_regex: cdktf.stringToTerraform(struct.branchNameRegex),
        commit_committer_check: cdktf.booleanToTerraform(struct.commitCommitterCheck),
        commit_message_negative_regex: cdktf.stringToTerraform(struct.commitMessageNegativeRegex),
        commit_message_regex: cdktf.stringToTerraform(struct.commitMessageRegex),
        deny_delete_tag: cdktf.booleanToTerraform(struct.denyDeleteTag),
        file_name_regex: cdktf.stringToTerraform(struct.fileNameRegex),
        max_file_size: cdktf.numberToTerraform(struct.maxFileSize),
        member_check: cdktf.booleanToTerraform(struct.memberCheck),
        prevent_secrets: cdktf.booleanToTerraform(struct.preventSecrets),
        reject_unsigned_commits: cdktf.booleanToTerraform(struct.rejectUnsignedCommits),
    };
}
exports.projectPushRulesToTerraform = projectPushRulesToTerraform;
class ProjectPushRulesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._authorEmailRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.authorEmailRegex = this._authorEmailRegex;
        }
        if (this._branchNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.branchNameRegex = this._branchNameRegex;
        }
        if (this._commitCommitterCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitCommitterCheck = this._commitCommitterCheck;
        }
        if (this._commitMessageNegativeRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageNegativeRegex = this._commitMessageNegativeRegex;
        }
        if (this._commitMessageRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.commitMessageRegex = this._commitMessageRegex;
        }
        if (this._denyDeleteTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.denyDeleteTag = this._denyDeleteTag;
        }
        if (this._fileNameRegex !== undefined) {
            hasAnyValues = true;
            internalValueResult.fileNameRegex = this._fileNameRegex;
        }
        if (this._maxFileSize !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxFileSize = this._maxFileSize;
        }
        if (this._memberCheck !== undefined) {
            hasAnyValues = true;
            internalValueResult.memberCheck = this._memberCheck;
        }
        if (this._preventSecrets !== undefined) {
            hasAnyValues = true;
            internalValueResult.preventSecrets = this._preventSecrets;
        }
        if (this._rejectUnsignedCommits !== undefined) {
            hasAnyValues = true;
            internalValueResult.rejectUnsignedCommits = this._rejectUnsignedCommits;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._authorEmailRegex = undefined;
            this._branchNameRegex = undefined;
            this._commitCommitterCheck = undefined;
            this._commitMessageNegativeRegex = undefined;
            this._commitMessageRegex = undefined;
            this._denyDeleteTag = undefined;
            this._fileNameRegex = undefined;
            this._maxFileSize = undefined;
            this._memberCheck = undefined;
            this._preventSecrets = undefined;
            this._rejectUnsignedCommits = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._authorEmailRegex = value.authorEmailRegex;
            this._branchNameRegex = value.branchNameRegex;
            this._commitCommitterCheck = value.commitCommitterCheck;
            this._commitMessageNegativeRegex = value.commitMessageNegativeRegex;
            this._commitMessageRegex = value.commitMessageRegex;
            this._denyDeleteTag = value.denyDeleteTag;
            this._fileNameRegex = value.fileNameRegex;
            this._maxFileSize = value.maxFileSize;
            this._memberCheck = value.memberCheck;
            this._preventSecrets = value.preventSecrets;
            this._rejectUnsignedCommits = value.rejectUnsignedCommits;
        }
    }
    get authorEmailRegex() {
        return this.getStringAttribute('author_email_regex');
    }
    set authorEmailRegex(value) {
        this._authorEmailRegex = value;
    }
    resetAuthorEmailRegex() {
        this._authorEmailRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authorEmailRegexInput() {
        return this._authorEmailRegex;
    }
    get branchNameRegex() {
        return this.getStringAttribute('branch_name_regex');
    }
    set branchNameRegex(value) {
        this._branchNameRegex = value;
    }
    resetBranchNameRegex() {
        this._branchNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchNameRegexInput() {
        return this._branchNameRegex;
    }
    get commitCommitterCheck() {
        return this.getBooleanAttribute('commit_committer_check');
    }
    set commitCommitterCheck(value) {
        this._commitCommitterCheck = value;
    }
    resetCommitCommitterCheck() {
        this._commitCommitterCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitCommitterCheckInput() {
        return this._commitCommitterCheck;
    }
    get commitMessageNegativeRegex() {
        return this.getStringAttribute('commit_message_negative_regex');
    }
    set commitMessageNegativeRegex(value) {
        this._commitMessageNegativeRegex = value;
    }
    resetCommitMessageNegativeRegex() {
        this._commitMessageNegativeRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageNegativeRegexInput() {
        return this._commitMessageNegativeRegex;
    }
    get commitMessageRegex() {
        return this.getStringAttribute('commit_message_regex');
    }
    set commitMessageRegex(value) {
        this._commitMessageRegex = value;
    }
    resetCommitMessageRegex() {
        this._commitMessageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commitMessageRegexInput() {
        return this._commitMessageRegex;
    }
    get denyDeleteTag() {
        return this.getBooleanAttribute('deny_delete_tag');
    }
    set denyDeleteTag(value) {
        this._denyDeleteTag = value;
    }
    resetDenyDeleteTag() {
        this._denyDeleteTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get denyDeleteTagInput() {
        return this._denyDeleteTag;
    }
    get fileNameRegex() {
        return this.getStringAttribute('file_name_regex');
    }
    set fileNameRegex(value) {
        this._fileNameRegex = value;
    }
    resetFileNameRegex() {
        this._fileNameRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileNameRegexInput() {
        return this._fileNameRegex;
    }
    get maxFileSize() {
        return this.getNumberAttribute('max_file_size');
    }
    set maxFileSize(value) {
        this._maxFileSize = value;
    }
    resetMaxFileSize() {
        this._maxFileSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxFileSizeInput() {
        return this._maxFileSize;
    }
    get memberCheck() {
        return this.getBooleanAttribute('member_check');
    }
    set memberCheck(value) {
        this._memberCheck = value;
    }
    resetMemberCheck() {
        this._memberCheck = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memberCheckInput() {
        return this._memberCheck;
    }
    get preventSecrets() {
        return this.getBooleanAttribute('prevent_secrets');
    }
    set preventSecrets(value) {
        this._preventSecrets = value;
    }
    resetPreventSecrets() {
        this._preventSecrets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preventSecretsInput() {
        return this._preventSecrets;
    }
    get rejectUnsignedCommits() {
        return this.getBooleanAttribute('reject_unsigned_commits');
    }
    set rejectUnsignedCommits(value) {
        this._rejectUnsignedCommits = value;
    }
    resetRejectUnsignedCommits() {
        this._rejectUnsignedCommits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rejectUnsignedCommitsInput() {
        return this._rejectUnsignedCommits;
    }
}
exports.ProjectPushRulesOutputReference = ProjectPushRulesOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ProjectPushRulesOutputReference[_b] = { fqn: "@cdktf/provider-gitlab.project.ProjectPushRulesOutputReference", version: "4.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project}
*/
class Project extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project gitlab_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.19.0',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // container_expiration_policy - computed: false, optional: true, required: false
        this._containerExpirationPolicy = new ProjectContainerExpirationPolicyOutputReference(this, "container_expiration_policy");
        // push_rules - computed: false, optional: true, required: false
        this._pushRules = new ProjectPushRulesOutputReference(this, "push_rules");
        this._allowMergeOnSkippedPipeline = config.allowMergeOnSkippedPipeline;
        this._analyticsAccessLevel = config.analyticsAccessLevel;
        this._approvalsBeforeMerge = config.approvalsBeforeMerge;
        this._archiveOnDestroy = config.archiveOnDestroy;
        this._archived = config.archived;
        this._autoCancelPendingPipelines = config.autoCancelPendingPipelines;
        this._autoDevopsDeployStrategy = config.autoDevopsDeployStrategy;
        this._autoDevopsEnabled = config.autoDevopsEnabled;
        this._autocloseReferencedIssues = config.autocloseReferencedIssues;
        this._buildCoverageRegex = config.buildCoverageRegex;
        this._buildGitStrategy = config.buildGitStrategy;
        this._buildTimeout = config.buildTimeout;
        this._buildsAccessLevel = config.buildsAccessLevel;
        this._ciConfigPath = config.ciConfigPath;
        this._ciDefaultGitDepth = config.ciDefaultGitDepth;
        this._ciForwardDeploymentEnabled = config.ciForwardDeploymentEnabled;
        this._containerRegistryAccessLevel = config.containerRegistryAccessLevel;
        this._containerRegistryEnabled = config.containerRegistryEnabled;
        this._defaultBranch = config.defaultBranch;
        this._description = config.description;
        this._emailsDisabled = config.emailsDisabled;
        this._externalAuthorizationClassificationLabel = config.externalAuthorizationClassificationLabel;
        this._forkingAccessLevel = config.forkingAccessLevel;
        this._groupWithProjectTemplatesId = config.groupWithProjectTemplatesId;
        this._id = config.id;
        this._importUrl = config.importUrl;
        this._initializeWithReadme = config.initializeWithReadme;
        this._issuesAccessLevel = config.issuesAccessLevel;
        this._issuesEnabled = config.issuesEnabled;
        this._issuesTemplate = config.issuesTemplate;
        this._lfsEnabled = config.lfsEnabled;
        this._mergeCommitTemplate = config.mergeCommitTemplate;
        this._mergeMethod = config.mergeMethod;
        this._mergePipelinesEnabled = config.mergePipelinesEnabled;
        this._mergeRequestsAccessLevel = config.mergeRequestsAccessLevel;
        this._mergeRequestsEnabled = config.mergeRequestsEnabled;
        this._mergeRequestsTemplate = config.mergeRequestsTemplate;
        this._mergeTrainsEnabled = config.mergeTrainsEnabled;
        this._mirror = config.mirror;
        this._mirrorOverwritesDivergedBranches = config.mirrorOverwritesDivergedBranches;
        this._mirrorTriggerBuilds = config.mirrorTriggerBuilds;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._onlyAllowMergeIfAllDiscussionsAreResolved = config.onlyAllowMergeIfAllDiscussionsAreResolved;
        this._onlyAllowMergeIfPipelineSucceeds = config.onlyAllowMergeIfPipelineSucceeds;
        this._onlyMirrorProtectedBranches = config.onlyMirrorProtectedBranches;
        this._operationsAccessLevel = config.operationsAccessLevel;
        this._packagesEnabled = config.packagesEnabled;
        this._pagesAccessLevel = config.pagesAccessLevel;
        this._path = config.path;
        this._pipelinesEnabled = config.pipelinesEnabled;
        this._printingMergeRequestLinkEnabled = config.printingMergeRequestLinkEnabled;
        this._publicBuilds = config.publicBuilds;
        this._removeSourceBranchAfterMerge = config.removeSourceBranchAfterMerge;
        this._repositoryAccessLevel = config.repositoryAccessLevel;
        this._repositoryStorage = config.repositoryStorage;
        this._requestAccessEnabled = config.requestAccessEnabled;
        this._requirementsAccessLevel = config.requirementsAccessLevel;
        this._resolveOutdatedDiffDiscussions = config.resolveOutdatedDiffDiscussions;
        this._securityAndComplianceAccessLevel = config.securityAndComplianceAccessLevel;
        this._sharedRunnersEnabled = config.sharedRunnersEnabled;
        this._skipWaitForDefaultBranchProtection = config.skipWaitForDefaultBranchProtection;
        this._snippetsAccessLevel = config.snippetsAccessLevel;
        this._snippetsEnabled = config.snippetsEnabled;
        this._squashCommitTemplate = config.squashCommitTemplate;
        this._squashOption = config.squashOption;
        this._suggestionCommitMessage = config.suggestionCommitMessage;
        this._tags = config.tags;
        this._templateName = config.templateName;
        this._templateProjectId = config.templateProjectId;
        this._topics = config.topics;
        this._useCustomTemplate = config.useCustomTemplate;
        this._visibilityLevel = config.visibilityLevel;
        this._wikiAccessLevel = config.wikiAccessLevel;
        this._wikiEnabled = config.wikiEnabled;
        this._containerExpirationPolicy.internalValue = config.containerExpirationPolicy;
        this._pushRules.internalValue = config.pushRules;
    }
    get allowMergeOnSkippedPipeline() {
        return this.getBooleanAttribute('allow_merge_on_skipped_pipeline');
    }
    set allowMergeOnSkippedPipeline(value) {
        this._allowMergeOnSkippedPipeline = value;
    }
    resetAllowMergeOnSkippedPipeline() {
        this._allowMergeOnSkippedPipeline = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowMergeOnSkippedPipelineInput() {
        return this._allowMergeOnSkippedPipeline;
    }
    get analyticsAccessLevel() {
        return this.getStringAttribute('analytics_access_level');
    }
    set analyticsAccessLevel(value) {
        this._analyticsAccessLevel = value;
    }
    resetAnalyticsAccessLevel() {
        this._analyticsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analyticsAccessLevelInput() {
        return this._analyticsAccessLevel;
    }
    get approvalsBeforeMerge() {
        return this.getNumberAttribute('approvals_before_merge');
    }
    set approvalsBeforeMerge(value) {
        this._approvalsBeforeMerge = value;
    }
    resetApprovalsBeforeMerge() {
        this._approvalsBeforeMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get approvalsBeforeMergeInput() {
        return this._approvalsBeforeMerge;
    }
    get archiveOnDestroy() {
        return this.getBooleanAttribute('archive_on_destroy');
    }
    set archiveOnDestroy(value) {
        this._archiveOnDestroy = value;
    }
    resetArchiveOnDestroy() {
        this._archiveOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnDestroyInput() {
        return this._archiveOnDestroy;
    }
    get archived() {
        return this.getBooleanAttribute('archived');
    }
    set archived(value) {
        this._archived = value;
    }
    resetArchived() {
        this._archived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archivedInput() {
        return this._archived;
    }
    get autoCancelPendingPipelines() {
        return this.getStringAttribute('auto_cancel_pending_pipelines');
    }
    set autoCancelPendingPipelines(value) {
        this._autoCancelPendingPipelines = value;
    }
    resetAutoCancelPendingPipelines() {
        this._autoCancelPendingPipelines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoCancelPendingPipelinesInput() {
        return this._autoCancelPendingPipelines;
    }
    get autoDevopsDeployStrategy() {
        return this.getStringAttribute('auto_devops_deploy_strategy');
    }
    set autoDevopsDeployStrategy(value) {
        this._autoDevopsDeployStrategy = value;
    }
    resetAutoDevopsDeployStrategy() {
        this._autoDevopsDeployStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsDeployStrategyInput() {
        return this._autoDevopsDeployStrategy;
    }
    get autoDevopsEnabled() {
        return this.getBooleanAttribute('auto_devops_enabled');
    }
    set autoDevopsEnabled(value) {
        this._autoDevopsEnabled = value;
    }
    resetAutoDevopsEnabled() {
        this._autoDevopsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDevopsEnabledInput() {
        return this._autoDevopsEnabled;
    }
    get autocloseReferencedIssues() {
        return this.getBooleanAttribute('autoclose_referenced_issues');
    }
    set autocloseReferencedIssues(value) {
        this._autocloseReferencedIssues = value;
    }
    resetAutocloseReferencedIssues() {
        this._autocloseReferencedIssues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autocloseReferencedIssuesInput() {
        return this._autocloseReferencedIssues;
    }
    get buildCoverageRegex() {
        return this.getStringAttribute('build_coverage_regex');
    }
    set buildCoverageRegex(value) {
        this._buildCoverageRegex = value;
    }
    resetBuildCoverageRegex() {
        this._buildCoverageRegex = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildCoverageRegexInput() {
        return this._buildCoverageRegex;
    }
    get buildGitStrategy() {
        return this.getStringAttribute('build_git_strategy');
    }
    set buildGitStrategy(value) {
        this._buildGitStrategy = value;
    }
    resetBuildGitStrategy() {
        this._buildGitStrategy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildGitStrategyInput() {
        return this._buildGitStrategy;
    }
    get buildTimeout() {
        return this.getNumberAttribute('build_timeout');
    }
    set buildTimeout(value) {
        this._buildTimeout = value;
    }
    resetBuildTimeout() {
        this._buildTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildTimeoutInput() {
        return this._buildTimeout;
    }
    get buildsAccessLevel() {
        return this.getStringAttribute('builds_access_level');
    }
    set buildsAccessLevel(value) {
        this._buildsAccessLevel = value;
    }
    resetBuildsAccessLevel() {
        this._buildsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildsAccessLevelInput() {
        return this._buildsAccessLevel;
    }
    get ciConfigPath() {
        return this.getStringAttribute('ci_config_path');
    }
    set ciConfigPath(value) {
        this._ciConfigPath = value;
    }
    resetCiConfigPath() {
        this._ciConfigPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciConfigPathInput() {
        return this._ciConfigPath;
    }
    get ciDefaultGitDepth() {
        return this.getNumberAttribute('ci_default_git_depth');
    }
    set ciDefaultGitDepth(value) {
        this._ciDefaultGitDepth = value;
    }
    resetCiDefaultGitDepth() {
        this._ciDefaultGitDepth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciDefaultGitDepthInput() {
        return this._ciDefaultGitDepth;
    }
    get ciForwardDeploymentEnabled() {
        return this.getBooleanAttribute('ci_forward_deployment_enabled');
    }
    set ciForwardDeploymentEnabled(value) {
        this._ciForwardDeploymentEnabled = value;
    }
    resetCiForwardDeploymentEnabled() {
        this._ciForwardDeploymentEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ciForwardDeploymentEnabledInput() {
        return this._ciForwardDeploymentEnabled;
    }
    get containerRegistryAccessLevel() {
        return this.getStringAttribute('container_registry_access_level');
    }
    set containerRegistryAccessLevel(value) {
        this._containerRegistryAccessLevel = value;
    }
    resetContainerRegistryAccessLevel() {
        this._containerRegistryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryAccessLevelInput() {
        return this._containerRegistryAccessLevel;
    }
    get containerRegistryEnabled() {
        return this.getBooleanAttribute('container_registry_enabled');
    }
    set containerRegistryEnabled(value) {
        this._containerRegistryEnabled = value;
    }
    resetContainerRegistryEnabled() {
        this._containerRegistryEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerRegistryEnabledInput() {
        return this._containerRegistryEnabled;
    }
    get defaultBranch() {
        return this.getStringAttribute('default_branch');
    }
    set defaultBranch(value) {
        this._defaultBranch = value;
    }
    resetDefaultBranch() {
        this._defaultBranch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultBranchInput() {
        return this._defaultBranch;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get emailsDisabled() {
        return this.getBooleanAttribute('emails_disabled');
    }
    set emailsDisabled(value) {
        this._emailsDisabled = value;
    }
    resetEmailsDisabled() {
        this._emailsDisabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailsDisabledInput() {
        return this._emailsDisabled;
    }
    get externalAuthorizationClassificationLabel() {
        return this.getStringAttribute('external_authorization_classification_label');
    }
    set externalAuthorizationClassificationLabel(value) {
        this._externalAuthorizationClassificationLabel = value;
    }
    resetExternalAuthorizationClassificationLabel() {
        this._externalAuthorizationClassificationLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalAuthorizationClassificationLabelInput() {
        return this._externalAuthorizationClassificationLabel;
    }
    get forkingAccessLevel() {
        return this.getStringAttribute('forking_access_level');
    }
    set forkingAccessLevel(value) {
        this._forkingAccessLevel = value;
    }
    resetForkingAccessLevel() {
        this._forkingAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forkingAccessLevelInput() {
        return this._forkingAccessLevel;
    }
    get groupWithProjectTemplatesId() {
        return this.getNumberAttribute('group_with_project_templates_id');
    }
    set groupWithProjectTemplatesId(value) {
        this._groupWithProjectTemplatesId = value;
    }
    resetGroupWithProjectTemplatesId() {
        this._groupWithProjectTemplatesId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupWithProjectTemplatesIdInput() {
        return this._groupWithProjectTemplatesId;
    }
    // http_url_to_repo - computed: true, optional: false, required: false
    get httpUrlToRepo() {
        return this.getStringAttribute('http_url_to_repo');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get importUrl() {
        return this.getStringAttribute('import_url');
    }
    set importUrl(value) {
        this._importUrl = value;
    }
    resetImportUrl() {
        this._importUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get importUrlInput() {
        return this._importUrl;
    }
    get initializeWithReadme() {
        return this.getBooleanAttribute('initialize_with_readme');
    }
    set initializeWithReadme(value) {
        this._initializeWithReadme = value;
    }
    resetInitializeWithReadme() {
        this._initializeWithReadme = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get initializeWithReadmeInput() {
        return this._initializeWithReadme;
    }
    get issuesAccessLevel() {
        return this.getStringAttribute('issues_access_level');
    }
    set issuesAccessLevel(value) {
        this._issuesAccessLevel = value;
    }
    resetIssuesAccessLevel() {
        this._issuesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesAccessLevelInput() {
        return this._issuesAccessLevel;
    }
    get issuesEnabled() {
        return this.getBooleanAttribute('issues_enabled');
    }
    set issuesEnabled(value) {
        this._issuesEnabled = value;
    }
    resetIssuesEnabled() {
        this._issuesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesEnabledInput() {
        return this._issuesEnabled;
    }
    get issuesTemplate() {
        return this.getStringAttribute('issues_template');
    }
    set issuesTemplate(value) {
        this._issuesTemplate = value;
    }
    resetIssuesTemplate() {
        this._issuesTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuesTemplateInput() {
        return this._issuesTemplate;
    }
    get lfsEnabled() {
        return this.getBooleanAttribute('lfs_enabled');
    }
    set lfsEnabled(value) {
        this._lfsEnabled = value;
    }
    resetLfsEnabled() {
        this._lfsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lfsEnabledInput() {
        return this._lfsEnabled;
    }
    get mergeCommitTemplate() {
        return this.getStringAttribute('merge_commit_template');
    }
    set mergeCommitTemplate(value) {
        this._mergeCommitTemplate = value;
    }
    resetMergeCommitTemplate() {
        this._mergeCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeCommitTemplateInput() {
        return this._mergeCommitTemplate;
    }
    get mergeMethod() {
        return this.getStringAttribute('merge_method');
    }
    set mergeMethod(value) {
        this._mergeMethod = value;
    }
    resetMergeMethod() {
        this._mergeMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeMethodInput() {
        return this._mergeMethod;
    }
    get mergePipelinesEnabled() {
        return this.getBooleanAttribute('merge_pipelines_enabled');
    }
    set mergePipelinesEnabled(value) {
        this._mergePipelinesEnabled = value;
    }
    resetMergePipelinesEnabled() {
        this._mergePipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergePipelinesEnabledInput() {
        return this._mergePipelinesEnabled;
    }
    get mergeRequestsAccessLevel() {
        return this.getStringAttribute('merge_requests_access_level');
    }
    set mergeRequestsAccessLevel(value) {
        this._mergeRequestsAccessLevel = value;
    }
    resetMergeRequestsAccessLevel() {
        this._mergeRequestsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsAccessLevelInput() {
        return this._mergeRequestsAccessLevel;
    }
    get mergeRequestsEnabled() {
        return this.getBooleanAttribute('merge_requests_enabled');
    }
    set mergeRequestsEnabled(value) {
        this._mergeRequestsEnabled = value;
    }
    resetMergeRequestsEnabled() {
        this._mergeRequestsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsEnabledInput() {
        return this._mergeRequestsEnabled;
    }
    get mergeRequestsTemplate() {
        return this.getStringAttribute('merge_requests_template');
    }
    set mergeRequestsTemplate(value) {
        this._mergeRequestsTemplate = value;
    }
    resetMergeRequestsTemplate() {
        this._mergeRequestsTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestsTemplateInput() {
        return this._mergeRequestsTemplate;
    }
    get mergeTrainsEnabled() {
        return this.getBooleanAttribute('merge_trains_enabled');
    }
    set mergeTrainsEnabled(value) {
        this._mergeTrainsEnabled = value;
    }
    resetMergeTrainsEnabled() {
        this._mergeTrainsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeTrainsEnabledInput() {
        return this._mergeTrainsEnabled;
    }
    get mirror() {
        return this.getBooleanAttribute('mirror');
    }
    set mirror(value) {
        this._mirror = value;
    }
    resetMirror() {
        this._mirror = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorInput() {
        return this._mirror;
    }
    get mirrorOverwritesDivergedBranches() {
        return this.getBooleanAttribute('mirror_overwrites_diverged_branches');
    }
    set mirrorOverwritesDivergedBranches(value) {
        this._mirrorOverwritesDivergedBranches = value;
    }
    resetMirrorOverwritesDivergedBranches() {
        this._mirrorOverwritesDivergedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorOverwritesDivergedBranchesInput() {
        return this._mirrorOverwritesDivergedBranches;
    }
    get mirrorTriggerBuilds() {
        return this.getBooleanAttribute('mirror_trigger_builds');
    }
    set mirrorTriggerBuilds(value) {
        this._mirrorTriggerBuilds = value;
    }
    resetMirrorTriggerBuilds() {
        this._mirrorTriggerBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mirrorTriggerBuildsInput() {
        return this._mirrorTriggerBuilds;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getNumberAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    resetNamespaceId() {
        this._namespaceId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get onlyAllowMergeIfAllDiscussionsAreResolved() {
        return this.getBooleanAttribute('only_allow_merge_if_all_discussions_are_resolved');
    }
    set onlyAllowMergeIfAllDiscussionsAreResolved(value) {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = value;
    }
    resetOnlyAllowMergeIfAllDiscussionsAreResolved() {
        this._onlyAllowMergeIfAllDiscussionsAreResolved = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfAllDiscussionsAreResolvedInput() {
        return this._onlyAllowMergeIfAllDiscussionsAreResolved;
    }
    get onlyAllowMergeIfPipelineSucceeds() {
        return this.getBooleanAttribute('only_allow_merge_if_pipeline_succeeds');
    }
    set onlyAllowMergeIfPipelineSucceeds(value) {
        this._onlyAllowMergeIfPipelineSucceeds = value;
    }
    resetOnlyAllowMergeIfPipelineSucceeds() {
        this._onlyAllowMergeIfPipelineSucceeds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyAllowMergeIfPipelineSucceedsInput() {
        return this._onlyAllowMergeIfPipelineSucceeds;
    }
    get onlyMirrorProtectedBranches() {
        return this.getBooleanAttribute('only_mirror_protected_branches');
    }
    set onlyMirrorProtectedBranches(value) {
        this._onlyMirrorProtectedBranches = value;
    }
    resetOnlyMirrorProtectedBranches() {
        this._onlyMirrorProtectedBranches = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onlyMirrorProtectedBranchesInput() {
        return this._onlyMirrorProtectedBranches;
    }
    get operationsAccessLevel() {
        return this.getStringAttribute('operations_access_level');
    }
    set operationsAccessLevel(value) {
        this._operationsAccessLevel = value;
    }
    resetOperationsAccessLevel() {
        this._operationsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsAccessLevelInput() {
        return this._operationsAccessLevel;
    }
    get packagesEnabled() {
        return this.getBooleanAttribute('packages_enabled');
    }
    set packagesEnabled(value) {
        this._packagesEnabled = value;
    }
    resetPackagesEnabled() {
        this._packagesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get packagesEnabledInput() {
        return this._packagesEnabled;
    }
    get pagesAccessLevel() {
        return this.getStringAttribute('pages_access_level');
    }
    set pagesAccessLevel(value) {
        this._pagesAccessLevel = value;
    }
    resetPagesAccessLevel() {
        this._pagesAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pagesAccessLevelInput() {
        return this._pagesAccessLevel;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    // path_with_namespace - computed: true, optional: false, required: false
    get pathWithNamespace() {
        return this.getStringAttribute('path_with_namespace');
    }
    get pipelinesEnabled() {
        return this.getBooleanAttribute('pipelines_enabled');
    }
    set pipelinesEnabled(value) {
        this._pipelinesEnabled = value;
    }
    resetPipelinesEnabled() {
        this._pipelinesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pipelinesEnabledInput() {
        return this._pipelinesEnabled;
    }
    get printingMergeRequestLinkEnabled() {
        return this.getBooleanAttribute('printing_merge_request_link_enabled');
    }
    set printingMergeRequestLinkEnabled(value) {
        this._printingMergeRequestLinkEnabled = value;
    }
    resetPrintingMergeRequestLinkEnabled() {
        this._printingMergeRequestLinkEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get printingMergeRequestLinkEnabledInput() {
        return this._printingMergeRequestLinkEnabled;
    }
    get publicBuilds() {
        return this.getBooleanAttribute('public_builds');
    }
    set publicBuilds(value) {
        this._publicBuilds = value;
    }
    resetPublicBuilds() {
        this._publicBuilds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get publicBuildsInput() {
        return this._publicBuilds;
    }
    get removeSourceBranchAfterMerge() {
        return this.getBooleanAttribute('remove_source_branch_after_merge');
    }
    set removeSourceBranchAfterMerge(value) {
        this._removeSourceBranchAfterMerge = value;
    }
    resetRemoveSourceBranchAfterMerge() {
        this._removeSourceBranchAfterMerge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removeSourceBranchAfterMergeInput() {
        return this._removeSourceBranchAfterMerge;
    }
    get repositoryAccessLevel() {
        return this.getStringAttribute('repository_access_level');
    }
    set repositoryAccessLevel(value) {
        this._repositoryAccessLevel = value;
    }
    resetRepositoryAccessLevel() {
        this._repositoryAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryAccessLevelInput() {
        return this._repositoryAccessLevel;
    }
    get repositoryStorage() {
        return this.getStringAttribute('repository_storage');
    }
    set repositoryStorage(value) {
        this._repositoryStorage = value;
    }
    resetRepositoryStorage() {
        this._repositoryStorage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get repositoryStorageInput() {
        return this._repositoryStorage;
    }
    get requestAccessEnabled() {
        return this.getBooleanAttribute('request_access_enabled');
    }
    set requestAccessEnabled(value) {
        this._requestAccessEnabled = value;
    }
    resetRequestAccessEnabled() {
        this._requestAccessEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestAccessEnabledInput() {
        return this._requestAccessEnabled;
    }
    get requirementsAccessLevel() {
        return this.getStringAttribute('requirements_access_level');
    }
    set requirementsAccessLevel(value) {
        this._requirementsAccessLevel = value;
    }
    resetRequirementsAccessLevel() {
        this._requirementsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requirementsAccessLevelInput() {
        return this._requirementsAccessLevel;
    }
    get resolveOutdatedDiffDiscussions() {
        return this.getBooleanAttribute('resolve_outdated_diff_discussions');
    }
    set resolveOutdatedDiffDiscussions(value) {
        this._resolveOutdatedDiffDiscussions = value;
    }
    resetResolveOutdatedDiffDiscussions() {
        this._resolveOutdatedDiffDiscussions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resolveOutdatedDiffDiscussionsInput() {
        return this._resolveOutdatedDiffDiscussions;
    }
    // runners_token - computed: true, optional: false, required: false
    get runnersToken() {
        return this.getStringAttribute('runners_token');
    }
    get securityAndComplianceAccessLevel() {
        return this.getStringAttribute('security_and_compliance_access_level');
    }
    set securityAndComplianceAccessLevel(value) {
        this._securityAndComplianceAccessLevel = value;
    }
    resetSecurityAndComplianceAccessLevel() {
        this._securityAndComplianceAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityAndComplianceAccessLevelInput() {
        return this._securityAndComplianceAccessLevel;
    }
    get sharedRunnersEnabled() {
        return this.getBooleanAttribute('shared_runners_enabled');
    }
    set sharedRunnersEnabled(value) {
        this._sharedRunnersEnabled = value;
    }
    resetSharedRunnersEnabled() {
        this._sharedRunnersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sharedRunnersEnabledInput() {
        return this._sharedRunnersEnabled;
    }
    get skipWaitForDefaultBranchProtection() {
        return this.getBooleanAttribute('skip_wait_for_default_branch_protection');
    }
    set skipWaitForDefaultBranchProtection(value) {
        this._skipWaitForDefaultBranchProtection = value;
    }
    resetSkipWaitForDefaultBranchProtection() {
        this._skipWaitForDefaultBranchProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipWaitForDefaultBranchProtectionInput() {
        return this._skipWaitForDefaultBranchProtection;
    }
    get snippetsAccessLevel() {
        return this.getStringAttribute('snippets_access_level');
    }
    set snippetsAccessLevel(value) {
        this._snippetsAccessLevel = value;
    }
    resetSnippetsAccessLevel() {
        this._snippetsAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsAccessLevelInput() {
        return this._snippetsAccessLevel;
    }
    get snippetsEnabled() {
        return this.getBooleanAttribute('snippets_enabled');
    }
    set snippetsEnabled(value) {
        this._snippetsEnabled = value;
    }
    resetSnippetsEnabled() {
        this._snippetsEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snippetsEnabledInput() {
        return this._snippetsEnabled;
    }
    get squashCommitTemplate() {
        return this.getStringAttribute('squash_commit_template');
    }
    set squashCommitTemplate(value) {
        this._squashCommitTemplate = value;
    }
    resetSquashCommitTemplate() {
        this._squashCommitTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashCommitTemplateInput() {
        return this._squashCommitTemplate;
    }
    get squashOption() {
        return this.getStringAttribute('squash_option');
    }
    set squashOption(value) {
        this._squashOption = value;
    }
    resetSquashOption() {
        this._squashOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get squashOptionInput() {
        return this._squashOption;
    }
    // ssh_url_to_repo - computed: true, optional: false, required: false
    get sshUrlToRepo() {
        return this.getStringAttribute('ssh_url_to_repo');
    }
    get suggestionCommitMessage() {
        return this.getStringAttribute('suggestion_commit_message');
    }
    set suggestionCommitMessage(value) {
        this._suggestionCommitMessage = value;
    }
    resetSuggestionCommitMessage() {
        this._suggestionCommitMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suggestionCommitMessageInput() {
        return this._suggestionCommitMessage;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get templateName() {
        return this.getStringAttribute('template_name');
    }
    set templateName(value) {
        this._templateName = value;
    }
    resetTemplateName() {
        this._templateName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateNameInput() {
        return this._templateName;
    }
    get templateProjectId() {
        return this.getNumberAttribute('template_project_id');
    }
    set templateProjectId(value) {
        this._templateProjectId = value;
    }
    resetTemplateProjectId() {
        this._templateProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get templateProjectIdInput() {
        return this._templateProjectId;
    }
    get topics() {
        return cdktf.Fn.tolist(this.getListAttribute('topics'));
    }
    set topics(value) {
        this._topics = value;
    }
    resetTopics() {
        this._topics = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicsInput() {
        return this._topics;
    }
    get useCustomTemplate() {
        return this.getBooleanAttribute('use_custom_template');
    }
    set useCustomTemplate(value) {
        this._useCustomTemplate = value;
    }
    resetUseCustomTemplate() {
        this._useCustomTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useCustomTemplateInput() {
        return this._useCustomTemplate;
    }
    get visibilityLevel() {
        return this.getStringAttribute('visibility_level');
    }
    set visibilityLevel(value) {
        this._visibilityLevel = value;
    }
    resetVisibilityLevel() {
        this._visibilityLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get visibilityLevelInput() {
        return this._visibilityLevel;
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get wikiAccessLevel() {
        return this.getStringAttribute('wiki_access_level');
    }
    set wikiAccessLevel(value) {
        this._wikiAccessLevel = value;
    }
    resetWikiAccessLevel() {
        this._wikiAccessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiAccessLevelInput() {
        return this._wikiAccessLevel;
    }
    get wikiEnabled() {
        return this.getBooleanAttribute('wiki_enabled');
    }
    set wikiEnabled(value) {
        this._wikiEnabled = value;
    }
    resetWikiEnabled() {
        this._wikiEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get wikiEnabledInput() {
        return this._wikiEnabled;
    }
    get containerExpirationPolicy() {
        return this._containerExpirationPolicy;
    }
    putContainerExpirationPolicy(value) {
        this._containerExpirationPolicy.internalValue = value;
    }
    resetContainerExpirationPolicy() {
        this._containerExpirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerExpirationPolicyInput() {
        return this._containerExpirationPolicy.internalValue;
    }
    get pushRules() {
        return this._pushRules;
    }
    putPushRules(value) {
        this._pushRules.internalValue = value;
    }
    resetPushRules() {
        this._pushRules.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushRulesInput() {
        return this._pushRules.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_merge_on_skipped_pipeline: cdktf.booleanToTerraform(this._allowMergeOnSkippedPipeline),
            analytics_access_level: cdktf.stringToTerraform(this._analyticsAccessLevel),
            approvals_before_merge: cdktf.numberToTerraform(this._approvalsBeforeMerge),
            archive_on_destroy: cdktf.booleanToTerraform(this._archiveOnDestroy),
            archived: cdktf.booleanToTerraform(this._archived),
            auto_cancel_pending_pipelines: cdktf.stringToTerraform(this._autoCancelPendingPipelines),
            auto_devops_deploy_strategy: cdktf.stringToTerraform(this._autoDevopsDeployStrategy),
            auto_devops_enabled: cdktf.booleanToTerraform(this._autoDevopsEnabled),
            autoclose_referenced_issues: cdktf.booleanToTerraform(this._autocloseReferencedIssues),
            build_coverage_regex: cdktf.stringToTerraform(this._buildCoverageRegex),
            build_git_strategy: cdktf.stringToTerraform(this._buildGitStrategy),
            build_timeout: cdktf.numberToTerraform(this._buildTimeout),
            builds_access_level: cdktf.stringToTerraform(this._buildsAccessLevel),
            ci_config_path: cdktf.stringToTerraform(this._ciConfigPath),
            ci_default_git_depth: cdktf.numberToTerraform(this._ciDefaultGitDepth),
            ci_forward_deployment_enabled: cdktf.booleanToTerraform(this._ciForwardDeploymentEnabled),
            container_registry_access_level: cdktf.stringToTerraform(this._containerRegistryAccessLevel),
            container_registry_enabled: cdktf.booleanToTerraform(this._containerRegistryEnabled),
            default_branch: cdktf.stringToTerraform(this._defaultBranch),
            description: cdktf.stringToTerraform(this._description),
            emails_disabled: cdktf.booleanToTerraform(this._emailsDisabled),
            external_authorization_classification_label: cdktf.stringToTerraform(this._externalAuthorizationClassificationLabel),
            forking_access_level: cdktf.stringToTerraform(this._forkingAccessLevel),
            group_with_project_templates_id: cdktf.numberToTerraform(this._groupWithProjectTemplatesId),
            id: cdktf.stringToTerraform(this._id),
            import_url: cdktf.stringToTerraform(this._importUrl),
            initialize_with_readme: cdktf.booleanToTerraform(this._initializeWithReadme),
            issues_access_level: cdktf.stringToTerraform(this._issuesAccessLevel),
            issues_enabled: cdktf.booleanToTerraform(this._issuesEnabled),
            issues_template: cdktf.stringToTerraform(this._issuesTemplate),
            lfs_enabled: cdktf.booleanToTerraform(this._lfsEnabled),
            merge_commit_template: cdktf.stringToTerraform(this._mergeCommitTemplate),
            merge_method: cdktf.stringToTerraform(this._mergeMethod),
            merge_pipelines_enabled: cdktf.booleanToTerraform(this._mergePipelinesEnabled),
            merge_requests_access_level: cdktf.stringToTerraform(this._mergeRequestsAccessLevel),
            merge_requests_enabled: cdktf.booleanToTerraform(this._mergeRequestsEnabled),
            merge_requests_template: cdktf.stringToTerraform(this._mergeRequestsTemplate),
            merge_trains_enabled: cdktf.booleanToTerraform(this._mergeTrainsEnabled),
            mirror: cdktf.booleanToTerraform(this._mirror),
            mirror_overwrites_diverged_branches: cdktf.booleanToTerraform(this._mirrorOverwritesDivergedBranches),
            mirror_trigger_builds: cdktf.booleanToTerraform(this._mirrorTriggerBuilds),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.numberToTerraform(this._namespaceId),
            only_allow_merge_if_all_discussions_are_resolved: cdktf.booleanToTerraform(this._onlyAllowMergeIfAllDiscussionsAreResolved),
            only_allow_merge_if_pipeline_succeeds: cdktf.booleanToTerraform(this._onlyAllowMergeIfPipelineSucceeds),
            only_mirror_protected_branches: cdktf.booleanToTerraform(this._onlyMirrorProtectedBranches),
            operations_access_level: cdktf.stringToTerraform(this._operationsAccessLevel),
            packages_enabled: cdktf.booleanToTerraform(this._packagesEnabled),
            pages_access_level: cdktf.stringToTerraform(this._pagesAccessLevel),
            path: cdktf.stringToTerraform(this._path),
            pipelines_enabled: cdktf.booleanToTerraform(this._pipelinesEnabled),
            printing_merge_request_link_enabled: cdktf.booleanToTerraform(this._printingMergeRequestLinkEnabled),
            public_builds: cdktf.booleanToTerraform(this._publicBuilds),
            remove_source_branch_after_merge: cdktf.booleanToTerraform(this._removeSourceBranchAfterMerge),
            repository_access_level: cdktf.stringToTerraform(this._repositoryAccessLevel),
            repository_storage: cdktf.stringToTerraform(this._repositoryStorage),
            request_access_enabled: cdktf.booleanToTerraform(this._requestAccessEnabled),
            requirements_access_level: cdktf.stringToTerraform(this._requirementsAccessLevel),
            resolve_outdated_diff_discussions: cdktf.booleanToTerraform(this._resolveOutdatedDiffDiscussions),
            security_and_compliance_access_level: cdktf.stringToTerraform(this._securityAndComplianceAccessLevel),
            shared_runners_enabled: cdktf.booleanToTerraform(this._sharedRunnersEnabled),
            skip_wait_for_default_branch_protection: cdktf.booleanToTerraform(this._skipWaitForDefaultBranchProtection),
            snippets_access_level: cdktf.stringToTerraform(this._snippetsAccessLevel),
            snippets_enabled: cdktf.booleanToTerraform(this._snippetsEnabled),
            squash_commit_template: cdktf.stringToTerraform(this._squashCommitTemplate),
            squash_option: cdktf.stringToTerraform(this._squashOption),
            suggestion_commit_message: cdktf.stringToTerraform(this._suggestionCommitMessage),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            template_name: cdktf.stringToTerraform(this._templateName),
            template_project_id: cdktf.numberToTerraform(this._templateProjectId),
            topics: cdktf.listMapper(cdktf.stringToTerraform, false)(this._topics),
            use_custom_template: cdktf.booleanToTerraform(this._useCustomTemplate),
            visibility_level: cdktf.stringToTerraform(this._visibilityLevel),
            wiki_access_level: cdktf.stringToTerraform(this._wikiAccessLevel),
            wiki_enabled: cdktf.booleanToTerraform(this._wikiEnabled),
            container_expiration_policy: projectContainerExpirationPolicyToTerraform(this._containerExpirationPolicy.internalValue),
            push_rules: projectPushRulesToTerraform(this._pushRules.internalValue),
        };
    }
}
exports.Project = Project;
_c = JSII_RTTI_SYMBOL_1;
Project[_c] = { fqn: "@cdktf/provider-gitlab.project.Project", version: "4.0.0" };
// =================
// STATIC PROPERTIES
// =================
Project.tfResourceType = "gitlab_project";
//# sourceMappingURL=data:application/json;base64,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