"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectIssue = exports.ProjectIssueTaskCompletionStatusList = exports.ProjectIssueTaskCompletionStatusOutputReference = exports.projectIssueTaskCompletionStatusToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function projectIssueTaskCompletionStatusToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.projectIssueTaskCompletionStatusToTerraform = projectIssueTaskCompletionStatusToTerraform;
class ProjectIssueTaskCompletionStatusOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // completed_count - computed: true, optional: false, required: false
    get completedCount() {
        return this.getNumberAttribute('completed_count');
    }
    // count - computed: true, optional: false, required: false
    get count() {
        return this.getNumberAttribute('count');
    }
}
exports.ProjectIssueTaskCompletionStatusOutputReference = ProjectIssueTaskCompletionStatusOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ProjectIssueTaskCompletionStatusOutputReference[_a] = { fqn: "@cdktf/provider-gitlab.projectIssue.ProjectIssueTaskCompletionStatusOutputReference", version: "4.0.0" };
class ProjectIssueTaskCompletionStatusList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ProjectIssueTaskCompletionStatusOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ProjectIssueTaskCompletionStatusList = ProjectIssueTaskCompletionStatusList;
_b = JSII_RTTI_SYMBOL_1;
ProjectIssueTaskCompletionStatusList[_b] = { fqn: "@cdktf/provider-gitlab.projectIssue.ProjectIssueTaskCompletionStatusList", version: "4.0.0" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue}
*/
class ProjectIssue extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_issue gitlab_project_issue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIssueConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_project_issue',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.19.0',
                providerVersionConstraint: '~> 3.14'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // links - computed: true, optional: false, required: false
        this._links = new cdktf.StringMap(this, "links");
        // references - computed: true, optional: false, required: false
        this._references = new cdktf.StringMap(this, "references");
        // task_completion_status - computed: true, optional: false, required: false
        this._taskCompletionStatus = new ProjectIssueTaskCompletionStatusList(this, "task_completion_status", false);
        this._assigneeIds = config.assigneeIds;
        this._confidential = config.confidential;
        this._createdAt = config.createdAt;
        this._deleteOnDestroy = config.deleteOnDestroy;
        this._description = config.description;
        this._discussionLocked = config.discussionLocked;
        this._discussionToResolve = config.discussionToResolve;
        this._dueDate = config.dueDate;
        this._epicIssueId = config.epicIssueId;
        this._id = config.id;
        this._iid = config.iid;
        this._issueType = config.issueType;
        this._labels = config.labels;
        this._mergeRequestToResolveDiscussionsOf = config.mergeRequestToResolveDiscussionsOf;
        this._milestoneId = config.milestoneId;
        this._project = config.project;
        this._state = config.state;
        this._title = config.title;
        this._updatedAt = config.updatedAt;
        this._weight = config.weight;
    }
    get assigneeIds() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('assignee_ids')));
    }
    set assigneeIds(value) {
        this._assigneeIds = value;
    }
    resetAssigneeIds() {
        this._assigneeIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assigneeIdsInput() {
        return this._assigneeIds;
    }
    // author_id - computed: true, optional: false, required: false
    get authorId() {
        return this.getNumberAttribute('author_id');
    }
    // closed_at - computed: true, optional: false, required: false
    get closedAt() {
        return this.getStringAttribute('closed_at');
    }
    // closed_by_user_id - computed: true, optional: false, required: false
    get closedByUserId() {
        return this.getNumberAttribute('closed_by_user_id');
    }
    get confidential() {
        return this.getBooleanAttribute('confidential');
    }
    set confidential(value) {
        this._confidential = value;
    }
    resetConfidential() {
        this._confidential = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get confidentialInput() {
        return this._confidential;
    }
    get createdAt() {
        return this.getStringAttribute('created_at');
    }
    set createdAt(value) {
        this._createdAt = value;
    }
    resetCreatedAt() {
        this._createdAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createdAtInput() {
        return this._createdAt;
    }
    get deleteOnDestroy() {
        return this.getBooleanAttribute('delete_on_destroy');
    }
    set deleteOnDestroy(value) {
        this._deleteOnDestroy = value;
    }
    resetDeleteOnDestroy() {
        this._deleteOnDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteOnDestroyInput() {
        return this._deleteOnDestroy;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get discussionLocked() {
        return this.getBooleanAttribute('discussion_locked');
    }
    set discussionLocked(value) {
        this._discussionLocked = value;
    }
    resetDiscussionLocked() {
        this._discussionLocked = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discussionLockedInput() {
        return this._discussionLocked;
    }
    get discussionToResolve() {
        return this.getStringAttribute('discussion_to_resolve');
    }
    set discussionToResolve(value) {
        this._discussionToResolve = value;
    }
    resetDiscussionToResolve() {
        this._discussionToResolve = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get discussionToResolveInput() {
        return this._discussionToResolve;
    }
    // downvotes - computed: true, optional: false, required: false
    get downvotes() {
        return this.getNumberAttribute('downvotes');
    }
    get dueDate() {
        return this.getStringAttribute('due_date');
    }
    set dueDate(value) {
        this._dueDate = value;
    }
    resetDueDate() {
        this._dueDate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dueDateInput() {
        return this._dueDate;
    }
    // epic_id - computed: true, optional: false, required: false
    get epicId() {
        return this.getNumberAttribute('epic_id');
    }
    get epicIssueId() {
        return this.getNumberAttribute('epic_issue_id');
    }
    set epicIssueId(value) {
        this._epicIssueId = value;
    }
    resetEpicIssueId() {
        this._epicIssueId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get epicIssueIdInput() {
        return this._epicIssueId;
    }
    // external_id - computed: true, optional: false, required: false
    get externalId() {
        return this.getStringAttribute('external_id');
    }
    // human_time_estimate - computed: true, optional: false, required: false
    get humanTimeEstimate() {
        return this.getStringAttribute('human_time_estimate');
    }
    // human_total_time_spent - computed: true, optional: false, required: false
    get humanTotalTimeSpent() {
        return this.getStringAttribute('human_total_time_spent');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get iid() {
        return this.getNumberAttribute('iid');
    }
    set iid(value) {
        this._iid = value;
    }
    resetIid() {
        this._iid = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iidInput() {
        return this._iid;
    }
    // issue_id - computed: true, optional: false, required: false
    get issueId() {
        return this.getNumberAttribute('issue_id');
    }
    // issue_link_id - computed: true, optional: false, required: false
    get issueLinkId() {
        return this.getNumberAttribute('issue_link_id');
    }
    get issueType() {
        return this.getStringAttribute('issue_type');
    }
    set issueType(value) {
        this._issueType = value;
    }
    resetIssueType() {
        this._issueType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issueTypeInput() {
        return this._issueType;
    }
    get labels() {
        return cdktf.Fn.tolist(this.getListAttribute('labels'));
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get links() {
        return this._links;
    }
    get mergeRequestToResolveDiscussionsOf() {
        return this.getNumberAttribute('merge_request_to_resolve_discussions_of');
    }
    set mergeRequestToResolveDiscussionsOf(value) {
        this._mergeRequestToResolveDiscussionsOf = value;
    }
    resetMergeRequestToResolveDiscussionsOf() {
        this._mergeRequestToResolveDiscussionsOf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mergeRequestToResolveDiscussionsOfInput() {
        return this._mergeRequestToResolveDiscussionsOf;
    }
    // merge_requests_count - computed: true, optional: false, required: false
    get mergeRequestsCount() {
        return this.getNumberAttribute('merge_requests_count');
    }
    get milestoneId() {
        return this.getNumberAttribute('milestone_id');
    }
    set milestoneId(value) {
        this._milestoneId = value;
    }
    resetMilestoneId() {
        this._milestoneId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get milestoneIdInput() {
        return this._milestoneId;
    }
    // moved_to_id - computed: true, optional: false, required: false
    get movedToId() {
        return this.getNumberAttribute('moved_to_id');
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get references() {
        return this._references;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    // subscribed - computed: true, optional: false, required: false
    get subscribed() {
        return this.getBooleanAttribute('subscribed');
    }
    get taskCompletionStatus() {
        return this._taskCompletionStatus;
    }
    // time_estimate - computed: true, optional: false, required: false
    get timeEstimate() {
        return this.getNumberAttribute('time_estimate');
    }
    get title() {
        return this.getStringAttribute('title');
    }
    set title(value) {
        this._title = value;
    }
    // Temporarily expose input value. Use with caution.
    get titleInput() {
        return this._title;
    }
    // total_time_spent - computed: true, optional: false, required: false
    get totalTimeSpent() {
        return this.getNumberAttribute('total_time_spent');
    }
    get updatedAt() {
        return this.getStringAttribute('updated_at');
    }
    set updatedAt(value) {
        this._updatedAt = value;
    }
    resetUpdatedAt() {
        this._updatedAt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updatedAtInput() {
        return this._updatedAt;
    }
    // upvotes - computed: true, optional: false, required: false
    get upvotes() {
        return this.getNumberAttribute('upvotes');
    }
    // user_notes_count - computed: true, optional: false, required: false
    get userNotesCount() {
        return this.getNumberAttribute('user_notes_count');
    }
    // web_url - computed: true, optional: false, required: false
    get webUrl() {
        return this.getStringAttribute('web_url');
    }
    get weight() {
        return this.getNumberAttribute('weight');
    }
    set weight(value) {
        this._weight = value;
    }
    resetWeight() {
        this._weight = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get weightInput() {
        return this._weight;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            assignee_ids: cdktf.listMapper(cdktf.numberToTerraform, false)(this._assigneeIds),
            confidential: cdktf.booleanToTerraform(this._confidential),
            created_at: cdktf.stringToTerraform(this._createdAt),
            delete_on_destroy: cdktf.booleanToTerraform(this._deleteOnDestroy),
            description: cdktf.stringToTerraform(this._description),
            discussion_locked: cdktf.booleanToTerraform(this._discussionLocked),
            discussion_to_resolve: cdktf.stringToTerraform(this._discussionToResolve),
            due_date: cdktf.stringToTerraform(this._dueDate),
            epic_issue_id: cdktf.numberToTerraform(this._epicIssueId),
            id: cdktf.stringToTerraform(this._id),
            iid: cdktf.numberToTerraform(this._iid),
            issue_type: cdktf.stringToTerraform(this._issueType),
            labels: cdktf.listMapper(cdktf.stringToTerraform, false)(this._labels),
            merge_request_to_resolve_discussions_of: cdktf.numberToTerraform(this._mergeRequestToResolveDiscussionsOf),
            milestone_id: cdktf.numberToTerraform(this._milestoneId),
            project: cdktf.stringToTerraform(this._project),
            state: cdktf.stringToTerraform(this._state),
            title: cdktf.stringToTerraform(this._title),
            updated_at: cdktf.stringToTerraform(this._updatedAt),
            weight: cdktf.numberToTerraform(this._weight),
        };
    }
}
exports.ProjectIssue = ProjectIssue;
_c = JSII_RTTI_SYMBOL_1;
ProjectIssue[_c] = { fqn: "@cdktf/provider-gitlab.projectIssue.ProjectIssue", version: "4.0.0" };
// =================
// STATIC PROPERTIES
// =================
ProjectIssue.tfResourceType = "gitlab_project_issue";
//# sourceMappingURL=data:application/json;base64,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