# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jumpscale',
 'jumpscale.clients._bcdb',
 'jumpscale.clients.btc_alpha',
 'jumpscale.clients.currencylayer',
 'jumpscale.clients.digitalocean',
 'jumpscale.clients.gedis',
 'jumpscale.clients.github',
 'jumpscale.clients.gogs',
 'jumpscale.clients.kraken',
 'jumpscale.clients.liquid',
 'jumpscale.clients.mail',
 'jumpscale.clients.name',
 'jumpscale.clients.s3',
 'jumpscale.clients.sendgrid',
 'jumpscale.clients.stellar',
 'jumpscale.clients.syncthing',
 'jumpscale.clients.taiga',
 'jumpscale.clients.zerotier',
 'jumpscale.core.identity',
 'jumpscale.data.countries',
 'jumpscale.data.treemanager',
 'jumpscale.entry_points',
 'jumpscale.install',
 'jumpscale.install.certbot',
 'jumpscale.packages.admin',
 'jumpscale.packages.admin.actors',
 'jumpscale.packages.admin.bottle',
 'jumpscale.packages.admin.services',
 'jumpscale.packages.auth',
 'jumpscale.packages.auth.bottle',
 'jumpscale.packages.backup',
 'jumpscale.packages.backup.actors',
 'jumpscale.packages.backup.services',
 'jumpscale.packages.billing',
 'jumpscale.packages.billing.services',
 'jumpscale.packages.chatflows',
 'jumpscale.packages.chatflows.actors',
 'jumpscale.packages.chatflows.bottle',
 'jumpscale.packages.codeserver',
 'jumpscale.packages.notebooks',
 'jumpscale.packages.polls',
 'jumpscale.packages.polls.bottle',
 'jumpscale.packages.polls.chats',
 'jumpscale.packages.stellar_stats',
 'jumpscale.packages.stellar_stats.bottle',
 'jumpscale.packages.weblibs',
 'jumpscale.sals.backupjob',
 'jumpscale.sals.billing',
 'jumpscale.sals.chatflows',
 'jumpscale.sals.chatflows.models',
 'jumpscale.sals.crtsh',
 'jumpscale.sals.nginx',
 'jumpscale.sals.nginx_proxy',
 'jumpscale.servers.appserver',
 'jumpscale.servers.gedis',
 'jumpscale.servers.gedis_http',
 'jumpscale.servers.threebot',
 'jumpscale.tools.dnstool',
 'jumpscale.tools.export',
 'jumpscale.tools.nginx',
 'jumpscale.tools.notificationsqueue',
 'jumpscale.tools.poolexecutor',
 'jumpscale.tools.qrcode',
 'jumpscale.tools.redis',
 'jumpscale.tools.restic',
 'jumpscale.tools.servicemanager',
 'jumpscale.tools.tfgateway',
 'jumpscale.tools.wireguard']

package_data = \
{'': ['*'],
 'jumpscale.install': ['rootfs/etc/zinit/*', 'vdc-services/*'],
 'jumpscale.packages.admin': ['frontend/*',
                              'frontend/assets/*',
                              'frontend/components/alerts/*',
                              'frontend/components/base/*',
                              'frontend/components/dashboard/*',
                              'frontend/components/external/*',
                              'frontend/components/legal/*',
                              'frontend/components/logs/*',
                              'frontend/components/packages/*',
                              'frontend/components/settings/*',
                              'frontend/components/wallets/*',
                              'frontend/components/wikis/*',
                              'frontend/mixins/*'],
 'jumpscale.packages.auth': ['static/css/*', 'static/img/*'],
 'jumpscale.packages.auth.bottle': ['templates/*'],
 'jumpscale.packages.backup': ['frontend/*'],
 'jumpscale.packages.chatflows': ['frontend/*',
                                  'frontend/assets/images/*',
                                  'frontend/components/*',
                                  'frontend/home/css/*',
                                  'frontend/home/img/*',
                                  'frontend/images/*',
                                  'frontend/mixins/*'],
 'jumpscale.packages.polls': ['images/*'],
 'jumpscale.sals.nginx': ['resources/*',
                          'static/*',
                          'static/images/*',
                          'templates/*'],
 'jumpscale.servers.threebot': ['templates/*']}

install_requires = \
['PyGithub>=1.43,<2.0',
 'base58>=2.0.0,<3.0.0',
 'beaker>=1.11.0,<2.0.0',
 'certbot-nginx>=1.31.0,<2.0.0',
 'certifi>=2019.6,<2020.0',
 'crontab>=0.22.9,<0.23.0',
 'cryptocompare>=0.6.4,<0.7.0',
 'cryptography==3.3.2',
 'dnspython>=1.16,<2.0',
 'gevent>=21.12.0,<22.0.0',
 'greenlet>=1.1.3,<2.0.0',
 'importlib-metadata>=4.0.1,<5.0.0',
 'js-ng==11.0b17',
 'minio>=4.0,<5.0',
 'namecom>=0.5.0,<0.6.0',
 'netaddr>=0.7.19,<0.8.0',
 'protobuf>=3.12.2,<4.0.0',
 'pycountry>=19.8,<20.0',
 'pypng>=0.0.20,<0.0.21',
 'pyqrcode>=1.2.1,<2.0.0',
 'python-digitalocean>=1.15.0,<2.0.0',
 'python-taiga>=1.0.0,<2.0.0',
 'requests_unixsocket>=0.2.0,<0.3.0',
 'sendgrid>=6.0,<7.0',
 'stellar-sdk>=8.1.0,<9.0.0']

entry_points = \
{'console_scripts': ['threebot = jumpscale.entry_points.threebot:cli']}

setup_kwargs = {
    'name': 'js-sdk',
    'version': '11.5b17',
    'description': 'SDK for threefold grid',
    'long_description': 'None',
    'author': 'xmonader',
    'author_email': 'xmonader@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
