from setuptools import setup

setup(
    name='docuseal',
    version='1.0.1',
    description='DocuSeal Python API client',
    url='https://github.com/docusealco/docuseal-python',
    author='DocuSeal',
    author_email='admin@docuseal.com',
    keywords="docuseal document signature",
    license='MIT',
    packages=['docuseal'],
    install_requires=[],
    python_requires=">=3.6",
    project_urls={
        "Bug Tracker": "https://github.com/docuseaoco/docuseal-python/issues",
        "Changes": "https://github.com/docuseaoco/docuseal-python/blob/master/CHANGELOG.md",
        "Documentation": "https://www.docuseal.com/docs/api?lang=python",
        "Source Code": "https://github.com/docuseaoco/docuseal-python",
    },
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    setup_requires=["wheel"],
)
